/*! ulakbus-ui  2016-05-23 */
"use strict";angular.module("ulakbus",["angular-loading-bar","ngRoute","ngSanitize","ngCookies","ulakbus.formService","ulakbus.dashboard","ulakbus.auth","ulakbus.error_pages","ulakbus.crud","ulakbus.debug","ulakbus.devSettings","ulakbus.version","gettext","markdown","templates-prod"]).constant("RESTURL",function(){var backendurl=location.href.indexOf("nightly")>-1?"//nightly.api.ulakbus.net/":"//api.ulakbus.net/";if(document.cookie.indexOf("backendurl")>-1){var cookiearray=document.cookie.split(";");angular.forEach(cookiearray,function(item){item.indexOf("backendurl")>-1&&(backendurl=item.split("=")[1],"/"!==backendurl.slice(-1)&&(backendurl+="/"),"http"!==backendurl.substring(0,4)&&(backendurl="http://"+backendurl))})}if(location.href.indexOf("backendurl")>-1){var urlfromqstr=location.href.split("?")[1].split("=")[1];backendurl=decodeURIComponent(urlfromqstr.replace(/\+/g," ")),"/"!==backendurl.slice(-1)&&(backendurl+="/"),"http"!==backendurl.substring(0,4)&&(backendurl="http://"+backendurl),document.cookie="backendurl="+backendurl,window.location.href=window.location.href.split("?")[0]}return{url:backendurl}}()).constant("toastr",window.toastr).constant("WS",window.WebSocket).config(function($logProvider){$logProvider.debugEnabled(!1)}).config(function(markdownProvider){}),angular.module("ulakbus").config(["$routeProvider",function($routeProvider,$route){$routeProvider.when("/login",{templateUrl:"components/auth/login.html",controller:"LoginController"}).when("/dashboard",{templateUrl:"components/dashboard/dashboard.html",controller:"DashController"}).when("/dev/settings",{templateUrl:"components/devSettings/devSettings.html",controller:"DevSettingsController"}).when("/debug/list",{templateUrl:"components/debug/debug.html",controller:"DebugController"}).when("/admin/bpmnmanager",{templateUrl:"components/admin/bpmn_manager.html",controller:"BpmnManagerController"}).when("/newdesigns",{templateUrl:"components/uitemplates/base.html",controller:"NewDesignsCtrl"}).when("/formservicepg",{templateUrl:"components/uitemplates/form_service_pg.html",controller:"FormServicePg"}).when("/:wf/",{templateUrl:"components/crud/templates/crud-preload.html",controller:"CRUDController"}).when("/:wf/do/:cmd",{templateUrl:"components/crud/templates/crud.html",controller:"CRUDListFormController"}).when("/:wf/do/:cmd/:key",{templateUrl:"components/crud/templates/crud.html",controller:"CRUDListFormController"}).when("/:wf/:model",{templateUrl:"components/crud/templates/crud-preload.html",controller:"CRUDController"}).when("/:wf/:model/do/:cmd",{templateUrl:"components/crud/templates/crud.html",controller:"CRUDListFormController"}).when("/:wf/:model/do/:cmd/:key",{templateUrl:"components/crud/templates/crud.html",controller:"CRUDListFormController"}).otherwise({redirectTo:"/dashboard"})}]).factory("IsOnline",function(){var isOnlineService={};return isOnlineService.status=navigator.onLine,isOnlineService.set_status=function(state){isOnlineService.status=state},isOnlineService.get_status=function(){return isOnlineService.status},isOnlineService}).run(function($window,$rootScope,$document,$route,IsOnline){var offlineMask=angular.element('<div class="body-mask"></div>');offlineMask.css({zIndex:"2010",opacity:"0.6"});var offlineAlert=angular.element('<div class="alert alert-danger text-center" role="alert">İnternet bağlantınız kesilmiştir. Bağlantı sağlandığında kaldığınız yerden devam edebilirsiniz.</div>').css({zIndex:"2011",position:"relative"}),body=$document.find("body").eq(0),is_online=navigator.onLine;is_online||body.append(offlineMask).append(offlineAlert),$window.addEventListener("offline",function(){is_online=!1,IsOnline.set_status(!1),body.append(offlineMask).append(offlineAlert)},!1),$window.addEventListener("online",function(){is_online=!0,IsOnline.set_status(!0),offlineMask.remove(),offlineAlert.remove(),$rootScope.current_user===!0&&window.location.reload()},!1)}).run(function($rootScope,AuthService){AuthService.check_auth(),$rootScope.loggedInUser=!1,$rootScope.loginAttempt=0,$rootScope.websocketIsOpen=!1,$rootScope.current_user=!0,$rootScope.$on("$routeChangeStart",function(event,next,current){})}).config(["$httpProvider",function($httpProvider){$httpProvider.defaults.withCredentials=!0}]).run(function(gettextCatalog){gettextCatalog.setCurrentLanguage("tr"),gettextCatalog.debug=!0}).config(["cfpLoadingBarProvider",function(cfpLoadingBarProvider){cfpLoadingBarProvider.includeBar=!1,cfpLoadingBarProvider.parentSelector="loaderdiv",cfpLoadingBarProvider.spinnerTemplate='<div class="loader">Loading...</div>'}]),angular.module("ulakbus").config(["$httpProvider",function($httpProvider){$httpProvider.interceptors.push(function(ErrorService,$q,$rootScope,$location,$timeout,$log,toastr){return{request:function(config){return"POST"===config.method&&(config.headers["Content-Type"]="text/plain"),config},response:function(response){return response.data._debug_queries&&response.data._debug_queries.length>0&&($rootScope.debug_queries=$rootScope.debug_queries||[],$rootScope.debug_queries.push({url:response.config.url,queries:response.data._debug_queries})),response.data.is_login===!1&&($rootScope.loggedInUser=response.data.is_login,$location.path("/login")),response.data.is_login===!0&&($rootScope.loggedInUser=!0,$rootScope.loginAttempt=1,"/login"===$location.path()&&$location.path("/dashboard")),response.data.notify&&toastr.info(response.data.notify),response},responseError:function(rejection){return ErrorService.handle(rejection,"http"),$q.reject(rejection)}}})}]),angular.module("ulakbus.formService",["ui.bootstrap"]).service("Moment",function(){return window.moment}).factory("Generator",function($http,$q,$timeout,$sce,$location,$route,$compile,$log,RESTURL,$rootScope,Moment,WSOps,FormConstraints,$uibModal){var generator={};return generator.makeUrl=function(scope){var getparams=scope.form_params.param?"?"+scope.form_params.param+"="+scope.form_params.id:"";return RESTURL.url+scope.url+getparams},generator.generate=function(scope,data){return $log.debug("data before generation:",data),data.forms?(angular.forEach(data.forms,function(value,key){scope[key]=data.forms[key]}),scope.client_cmd=data.client_cmd,scope.token=data.token,scope.initialModel=angular.copy(scope.model),generator.prepareFormItems(scope),scope.object_id=scope.form_params.object_id,$log.debug("scope at after generate",scope),scope):scope},generator.group=function(scope){if(!scope.grouping)return scope;var newForm=[],extractFormItem=function(itemList){var extractedList=[];return angular.forEach(itemList,function(value,key){var item=getFormItem(value);item&&extractedList.push(item)}),$log.debug("extractedList: ",extractedList),extractedList},getFormItem=function(item){var formItem;return scope.form.indexOf(item)>-1?(formItem=scope.form[scope.form.indexOf(item)],scope.form.splice(scope.form.indexOf(item),1),formItem):(angular.forEach(scope.form,function(value,key){return value.key===item?(formItem=value,void scope.form.splice(key,1)):void 0}),formItem)},makeGroup=function(itemsToGroup){var subItems=[];return angular.forEach(itemsToGroup,function(value,key){subItems.push({type:"fieldset",items:extractFormItem(value.items),title:value.group_title})}),subItems};return angular.forEach(scope.grouping,function(value,key){newForm.push({type:"fieldset",items:makeGroup(value.groups),htmlClass:"col-md-"+value.layout,title:value.group_title})}),newForm.length>0&&($log.debug("grouped form: ",newForm),$log.debug("rest of form: ",scope.form),$log.debug("form united: ",newForm.concat(scope.form))),scope.form=newForm.concat(scope.form),scope},generator.constraints=function(scope){return angular.forEach(scope.form,function(v,k){try{var cons=scope.forms.constraints[v]||scope.forms.constraints[v.key];angular.isDefined(cons)&&(v.constructor===String?scope.form[k]={key:v,validationMessage:{form_cons:cons.val_msg},$validators:{form_cons:function(value){return FormConstraints[cons.cons](value,cons.val,v)}}}:(v.key=v.key,v.validationMessage=angular.extend({form_cons:cons.val_msg},v.validationMessage),v.$validators=angular.extend({form_cons:function(value){return FormConstraints[cons.cons](value,cons.val,v.key)}},v.$asyncValidators)))}catch(e){$log.error(e.message)}}),generator.group(scope)},generator.prepareFormItems=function(scope){angular.forEach(scope.form,function(value,key){"select"===value.type&&(scope.schema.properties[value.key].type="select",scope.schema.properties[value.key].titleMap=value.titleMap,scope.form[key]=value.key)});var _buttons=function(scope,v,k){var buttonPositions=scope.modalElements?scope.modalElements.buttonPositions:{bottom:"move-to-bottom",top:"move-to-top",none:""},workOnForm=scope.modalElements?scope.modalElements.workOnForm:"formgenerated",workOnDiv=scope.modalElements?scope.modalElements.workOnDiv:"",buttonClass=buttonPositions[v.position]||buttonPositions.bottom,redirectTo=!scope.modalElements;scope.form[scope.form.indexOf(k)]={type:v.type,title:v.title,style:(v.style||"btn-danger")+" hide bottom-margined "+buttonClass,onClick:function(){delete scope.form_params.cmd,delete scope.form_params.flow,v.cmd&&(scope.form_params.cmd=v.cmd),v.flow&&(scope.form_params.flow=v.flow),v.wf&&(delete scope.form_params.cmd,scope.form_params.wf=v.wf),scope.model[k]=1,scope.modalElements?scope.submitModalForm():!v.form_validate&&angular.isDefined(v.form_validate)?generator.submit(scope,redirectTo):(scope.$broadcast("schemaFormValidate"),scope[workOnForm].$valid?(generator.submit(scope,redirectTo),scope.$broadcast("disposeModal")):$timeout(function(){var firsterror=angular.element(document.querySelectorAll("input.ng-invalid"))[0];firsterror.focus()}))}},$timeout(function(){var selectorBottom=".buttons-on-bottom"+workOnDiv,buttonsToBottom=angular.element(document.querySelector("."+buttonClass));angular.element(document.querySelector(selectorBottom)).append(buttonsToBottom),buttonsToBottom.removeClass("hide")},500)},_numbers=function(scope,v,k){v.type="number",v.validationMessage={max:"bu alan -2147483647 ve 2147483647 arasında olmalıdır."},v.$validators={max:function(value){return 2147483647>value>-2147483647}},scope.model[k]=parseInt(scope.model[k])},_node_default=function(scope,v,k){scope[v.type]=scope[v.type]||{},scope[v.type][k]=angular.copy({title:v.title,form:[],schema:{properties:{},required:[],title:v.title,type:"object",formType:v.type,model_name:k,inline_edit:scope.inline_edit},buttons:v.buttons,url:scope.url,wf:v.wf||scope.wf,quick_add:v.quick_add,quick_add_view:v.quick_add_view,quick_add_model:v.quick_add_model,quick_add_field:v.quick_add_field,nodeModelChange:function(item){}}),angular.forEach(v.schema,function(item){scope[v.type][k].schema.properties[item.name]=angular.copy(item),angular.isDefined(item.wf)&&(scope[v.type][k].schema.properties[item.name].wf=angular.copy(item.wf)),item.required===!0&&"idx"!==item.name&&scope[v.type][k].schema.required.push(angular.copy(item.name)),"idx"!==item.name&&scope[v.type][k].form.push(item.name);try{"date"===item.type}catch(e){$log.debug("Error: ",e.message)}}),$timeout(function(){"ListNode"===v.type&&(scope[v.type][k].items=angular.copy(scope.model[k]||[]),angular.forEach(scope[v.type][k].items,function(value,key){value.constructor===Object&&angular.forEach(value,function(x,y){try{"date"===scope[v.type][k].schema.properties[y].type&&(scope[v.type][k].items[key][y]=generator.dateformatter(x),scope[v.type][k].model[key][y]=generator.dateformatter(x)),"select"===scope[v.type][k].schema.properties[y].type&&(scope[v.type][k].items[key][y]=generator.item_from_array(x.toString(),scope[v.type][k].schema.properties[y].titleMap))}catch(e){$log.debug("Field is not date")}})}))}),scope.model[k]&&angular.forEach(scope.model[k],function(value,key){angular.forEach(value,function(y,x){y.constructor===Object&&(scope.model[k][key][x]=y.key)})}),scope.model[k]=scope.model[k]||[],scope[v.type][k].model=scope.model[k],scope[v.type][k].lengthModels=scope.model[k]?1:0},_node_filter_interface=function(scope,v,k){var formitem=scope.form[scope.form.indexOf(k)],modelScope={form_params:{wf:v.wf||scope.wf||scope.form_params.wf,model:v.model_name||v.schema[0].model_name,cmd:v.list_cmd||"select_list",query:""}};scope.generateTitleMap=function(modelScope){generator.get_list(modelScope).then(function(res){formitem.titleMap=[],angular.forEach(res.objects,function(item){"-1"!==item&&formitem.titleMap.push({value:item.key,name:item.value})}),formitem.filteredItems=generator.get_diff_array(angular.copy(formitem.titleMap),angular.copy(formitem.selectedFilteredItems),1)})};var modelItems=[],modelKeys=[];angular.forEach(scope.model[k],function(value,mkey){modelItems.push({value:value[v.schema[0].name].key,name:value[v.schema[0].name].unicode});var modelKey={};modelKey[v.schema[0].name]=value[v.schema[0].name].key,modelKeys.push(modelKey)}),scope.model[k]=angular.copy(modelKeys),formitem={type:"template",templateUrl:"shared/templates/multiselect.html",title:v.title,formName:k,wf:v.wf||scope.wf,add_cmd:v.add_cmd,name:v.model_name||v.schema[0].model_name,model_name:v.model_name||v.schema[0].model_name,filterValue:"",selected_item:{},filteredItems:[],selectedFilteredItems:modelItems,titleMap:scope.generateTitleMap(modelScope),appendFiltered:function(filterValue){filterValue.length>2&&(formitem.filteredItems=[],angular.forEach(formitem.titleMap,function(value,key){value.name.indexOf(filterValue)>-1&&formitem.filteredItems.push(formitem.titleMap[key])})),2>=filterValue&&(formitem.filteredItems=formitem.titleMap),formitem.filteredItems=generator.get_diff_array(formitem.filteredItems,formitem.selectedFilteredItems)},select:function(selectedItemsModel){selectedItemsModel&&(formitem.selectedFilteredItems=formitem.selectedFilteredItems.concat(selectedItemsModel),formitem.appendFiltered(formitem.filterValue),scope.model[k]=(scope.model[k]||[]).concat(formitem.dataToModel(selectedItemsModel)))},deselect:function(selectedFilteredItemsModel){selectedFilteredItemsModel&&(formitem.selectedFilteredItems=generator.get_diff_array(angular.copy(formitem.selectedFilteredItems),angular.copy(selectedFilteredItemsModel)),formitem.appendFiltered(formitem.filterValue),formitem.filteredItems=formitem.filteredItems.concat(selectedFilteredItemsModel),scope.model[k]=generator.get_diff_array(scope.model[k]||[],formitem.dataToModel(selectedFilteredItemsModel)))},dataToModel:function(data){var dataValues=[];return angular.forEach(data,function(value,key){var dataKey={};dataKey[v.schema[0].name]=value.value,dataValues.push(dataKey)}),dataValues}},scope.form[scope.form.indexOf(k)]=formitem},generate_fields={button:{"default":_buttons},submit:{"default":_buttons},file:{"default":function(scope,v,k){scope.form[scope.form.indexOf(k)]={type:"template",title:v.title,templateUrl:"shared/templates/filefield.html",name:k,key:k,fileInsert:function(){$scope.$broadcast("schemaForm.error."+k,"tv4-302",!0)},imageSrc:scope.model[k]?$rootScope.settings.static_url+scope.model[k]:"",avatar:"avatar"===k},v.type="string"}},select:{"default":function(scope,v,k){scope.form[scope.form.indexOf(k)]={type:"template",title:v.title,templateUrl:"shared/templates/select.html",name:k,key:k,titleMap:v.titleMap}}},confirm:{"default":function(scope,v,k){scope.form[scope.form.indexOf(k)]={type:"template",title:v.title,confirm_message:v.confirm_message,templateUrl:"shared/templates/confirm.html",name:k,key:k,style:v.style,buttons:v.buttons,modalInstance:"",modalFunction:function(){delete scope.form_params.cmd,delete scope.form_params.flow,v.cmd&&(scope.form_params.cmd=v.cmd),v.flow&&(scope.form_params.flow=v.flow),v.wf&&(delete scope.form_params.cmd,scope.form_params.wf=v.wf);var modalInstance=$uibModal.open({animation:!0,templateUrl:"shared/templates/confirmModalContent.html",controller:"ModalController",resolve:{items:function(){var newscope={form:{title:v.title,confirm_message:v.confirm_message,buttons:v.buttons,onClick:function(cmd){modalInstance.dismiss(),cmd&&generator.submit(scope,!1)}}};return newscope}}})},openModal:function(){var workOnForm=scope.modalElements?scope.modalElements.workOnForm:"formgenerated";!v.form_validate&&angular.isDefined(v.form_validate)?this.modalFunction():(scope.$broadcast("schemaFormValidate"),scope[workOnForm].$valid?this.modalFunction():$timeout(function(){var firsterror=angular.element(document.querySelectorAll("input.ng-invalid"))[0];firsterror.focus()}))}}}},date:{"default":function(scope,v,k){$log.debug("date:",scope.model[k]),scope.model[k]=generator.dateformatter(scope.model[k]),scope.form[scope.form.indexOf(k)]={key:k,name:k,title:v.title,type:"template",templateUrl:"shared/templates/datefield.html",validationMessage:{dateNotValid:"Girdiğiniz tarih geçerli değildir. <i>orn: '01.01.2015'<i/>",302:"Bu alan zorunludur."},$asyncValidators:{dateNotValid:function(value){var deferred=$q.defer();return $timeout(function(){if(scope.model[k]=angular.copy(generator.dateformatter(value)),scope.schema.required.indexOf(k)>-1&&deferred.resolve(),value.constructor===Date)deferred.resolve();else{var dateValue=d=value.split(".");isNaN(Date.parse(value))||3!==dateValue.length?deferred.reject():deferred.resolve()}}),deferred.promise}},disabled:!1,is_disabled:function(){return this.disabled},status:{opened:!1},open:function($event){this.disabled=!0,scope.model[k]=Moment(scope.model[k],"DD.MM.YYYY").toDate();var that=this;$timeout(function(){that.status.opened=!0},100)},format:"dd.MM.yyyy",onSelect:function(){this.disabled=!1,scope.model[k]=angular.copy(generator.dateformatter(scope.model[k]))}}}},"int":{"default":_numbers},"boolean":{"default":function(scope,v,k){}},string:{"default":function(scope,v,k){}},typeahead:{"default":function(scope,v,k){scope.form[scope.form.indexOf(k)]={type:"template",title:v.title,titleMap:v.titleMap,templateUrl:"shared/templates/typeahead.html",name:k,key:k,onDropdownSelect:function(item,inputname){scope.model[k]=item.value,$timeout(function(){document.querySelector("input[name="+inputname+"]").value=item.name})}},v.type="string"}},text_general:{"default":function(scope,v,k){v.type="string",v["x-schema-form"]={type:"textarea"}}},"float":{"default":_numbers},model:{"default":function(scope,v,k){var formitem=scope.form[scope.form.indexOf(k)],modelScope={url:v.wf,wf:v.wf,form_params:{wf:v.wf,model:v.model_name,cmd:v.list_cmd}},generateTitleMap=function(modelScope){return generator.get_list(modelScope).then(function(res){return formitem.titleMap=[],angular.forEach(res.objects,function(item){-1!==item?formitem.titleMap.push({value:item.key,name:item.value}):formitem.focusToInput=!0}),formitem.titleMap})};formitem={type:"template",templateUrl:"shared/templates/foreignKey.html",formName:k,title:v.title,wf:v.wf,add_cmd:v.add_cmd,name:k,key:k,model_name:v.model_name,selected_item:{},titleMap:[],onSelect:function(item,inputname){scope.model[k]=item.value,$timeout(function(){document.querySelector("input[name="+inputname+"]").value=item.name})},onDropdownSelect:function(item,inputname){scope.model[k]=item.value,$timeout(function(){document.querySelector("input[name="+inputname+"]").value=item.name})},getTitleMap:function(viewValue){return modelScope.form_params.query=viewValue,generateTitleMap(modelScope)},getDropdownTitleMap:function(){delete modelScope.form_params.query,formitem.gettingTitleMap=!0,generateTitleMap(modelScope).then(function(data){formitem.titleMap=data,formitem.gettingTitleMap=!1})}},scope.form[scope.form.indexOf(k)]=formitem,scope.model[k]&&generator.get_list({url:"crud",form_params:{wf:v.wf,model:v.model_name,object_id:scope.model[k],cmd:"object_name"}}).then(function(data){try{$timeout(function(){document.querySelector("input[name="+k+"]").value=data.object_name},200)}catch(e){document.querySelector("input[name="+k+"]").value=data.object_name,$log.debug("exception",e)}})}},Node:{"default":_node_default,filter_interface:_node_filter_interface},ListNode:{"default":_node_default,filter_interface:_node_filter_interface}};angular.forEach(scope.schema.properties,function(v,k){if("form_params"in scope&&k==scope.form_params.param)return scope.model[k]=scope.form_params.id,void scope.form.splice(scope.form.indexOf(k),1);try{generate_fields[v.type][v.widget||"default"](scope,v,k)}catch(e){console.log(v.type)}}),$log.debug("scope at after prepareformitems",scope),generator.constraints(scope)},generator.dateformatter=function(formObject){var ndate=new Date(formObject);if(isNaN(ndate))return"";var newdatearray=Moment(ndate).format("DD.MM.YYYY");return $log.debug("date formatted: ",newdatearray),newdatearray},generator.doItemAction=function($scope,key,todo,mode){$scope.form_params.cmd=todo.cmd,$scope.form_params.wf=$scope.wf,todo.wf&&($scope.url=todo.wf,$scope.form_params.wf=todo.wf,delete $scope.token,delete $scope.form_params.model,delete $scope.form_params.cmd),todo.object_key?$scope.form_params[todo.object_key]=key:$scope.form_params.object_id=key,$scope.form_params.param=$scope.param,$scope.form_params.id=$scope.param_id,$scope.form_params.token=$scope.token;var _do={normal:function(){return $log.debug("normal mode starts"),generator.get_wf($scope)},modal:function(){$log.debug("modal mode starts");var modalInstance=$uibModal.open({animation:!0,backdrop:"static",keyboard:!1,templateUrl:"shared/templates/confirmModalContent.html",controller:"ModalController",size:"",resolve:{items:function(){var newscope={form:{buttons:[{text:"Evet",style:"btn-success",cmd:"confirm"},{text:"Hayir",style:"btn-warning",dismiss:!0}],title:todo.name,confirm_message:"Islemi onayliyor musunuz?",onClick:function(cmd){return modalInstance.close(),"confirm"===cmd&&angular.isDefined(cmd)?(modalInstance.close(),generator.get_wf($scope)):void 0}}};return newscope}}})},"new":function(){$log.debug("new mode is not not ready")}};return _do[mode]()},generator.button_switch=function(position){var buttons=angular.element(document.querySelectorAll("button")),positions={"true":"enabled","false":"disabled"};angular.forEach(buttons,function(button,key){button[positions[position]]=!0}),$log.debug("buttons >> ",positions[position])},generator.get_form=function(scope){return $rootScope.websocketIsOpen===!0?WSOps.request(scope.form_params).then(function(data){return generator.generate(scope,data)}):void $timeout(function(){generator.get_form(scope)},500)},generator.get_list=function(scope){return $rootScope.websocketIsOpen===!0?WSOps.request(scope.form_params).then(function(data){return data}):void $timeout(function(){generator.get_list(scope)},500)},generator.get_wf=function(scope){$rootScope.websocketIsOpen===!0?WSOps.request(scope.form_params).then(function(data){return generator.pathDecider(data.client_cmd||["list"],scope,data)}):$timeout(function(){generator.get_wf(scope)},500)},generator.pageData={},generator.getPageData=function(){return generator.pageData},generator.setPageData=function(value){generator.pageData=value},generator.pathDecider=function(client_cmd,$scope,data){function redirectTo(scope,page){var pathUrl="/"+scope.form_params.wf;return pathUrl+=scope.form_params.model?"/"+scope.form_params.model+"/do/"+page:"/do/"+page,$location.path()===pathUrl?$route.reload():void $location.path(pathUrl)}function dispatchClientCmd(){data[$scope.form_params.param]=$scope.form_params.id,data.model=$scope.form_params.model,data.wf=$scope.form_params.wf,data.param=$scope.form_params.param,data.param_id=$scope.form_params.id,data.pageData=!0,generator.setPageData(data),redirectTo($scope,client_cmd[0])}dispatchClientCmd()},generator.get_diff=function(oldObj,newObj){var result={};return angular.forEach(newObj,function(value,key){oldObj[key]?oldObj[key].constructor!==newObj[key].constructor||newObj[key].constructor!==Object&&newObj[key].constructor!==Array?oldObj[key]!=newObj[key]&&(result[key]=angular.copy(newObj[key])):angular.forEach(value,function(v,k){oldObj[key][k]!=value[k]&&(result[key][k]=angular.copy(value[k]))}):result[key]=angular.copy(newObj[key])}),result},generator.get_diff_array=function(array1,array2,way){var result=[];return angular.forEach(array1,function(value,key){1===way?angular.toJson(array2).indexOf(value.value)<0&&result.push(value):angular.toJson(array2).indexOf(angular.toJson(value))<0&&result.push(value)}),result},generator.item_from_array=function(item,array){var result=item;return angular.forEach(array,function(value,key){value.value===item&&(result=value.name)}),result},generator.submit=function($scope,redirectTo){angular.forEach($scope.ListNode,function(value,key){$scope.model[key]=value.model}),angular.forEach($scope.Node,function(value,key){$scope.model[key]=value.model});var send_data={form:$scope.model,object_key:$scope.object_key,token:$scope.token,model:$scope.form_params.model,wf:$scope.form_params.wf,cmd:$scope.form_params.cmd,flow:$scope.form_params.flow,object_id:$scope.object_id,filter:$scope.filter,query:$scope.form_params.query};$rootScope.websocketIsOpen===!0?WSOps.request(send_data).then(function(data){return generator.pathDecider(data.client_cmd||["list"],$scope,data)}):$timeout(function(){generator.scope($scope,redirectTo)},500)},generator}).controller("ModalController",function($scope,$uibModalInstance,Generator,items){angular.forEach(items,function(value,key){$scope[key]=items[key]}),$scope.$on("disposeModal",function(){$scope.cancel()}),$scope.$on("modalFormLocator",function(event){$scope.linkedModelForm=event.targetScope.linkedModelForm}),$scope.$on("submitModalForm",function(){$scope.onSubmit($scope.linkedModelForm)}),$scope.$on("validateModalDate",function(event,field){$scope.$broadcast("schemaForm.error."+field,"tv4-302",!0)}),$scope.onSubmit=function(form){$scope.$broadcast("schemaFormValidate"),form.$valid&&$uibModalInstance.close($scope)},$scope.onNodeBtnClk=function(button){!button.form_validate&&angular.isDefined(button.form_validate)?$uibModalInstance.close($scope):($scope.$broadcast("schemaFormValidate"),$scope.modalForm.$valid?$uibModalInstance.close($scope):$timeout(function(){var firsterror=angular.element(document.querySelectorAll("input.ng-invalid"))[0];firsterror.focus()}))},$scope.cancel=function(){$uibModalInstance.dismiss("cancel")}}).directive("modalForNodes",function($uibModal,Generator){return{link:function(scope,element,attributes){element.on("click",function(){var modalInstance=$uibModal.open({animation:!0,backdrop:"static",keyboard:!1,templateUrl:"shared/templates/listnodeModalContent.html",controller:"ModalController",size:"lg",resolve:{items:function(){var attribs=attributes.modalForNodes.split(","),node=angular.copy(scope.$parent[attribs[1]][attribs[0]]);"add"===attribs[2]&&(node.model={}),attribs[3]&&(node.model=node.model[attribs[3]]),node.edit=attribs[3],scope.node.schema.wf=scope.node.url,angular.forEach(scope.node.schema.properties,function(value,key){angular.isDefined(scope.node.schema.properties[key].wf)||(scope.node.schema.properties[key].wf=scope.node.url),scope.node.schema.properties[key].list_cmd="select_list"});var newscope={wf:scope.node.wf,url:scope.node.url,form_params:{model:scope.node.schema.model_name},edit:attribs[3]};return Generator.generate(newscope,{forms:scope.node}),newscope.model=newscope.model[node.edit]||{},newscope}}});modalInstance.result.then(function(childmodel,key){var listNodeItem=scope.$parent[childmodel.schema.formType][childmodel.schema.model_name];if("Node"===childmodel.schema.formType&&(listNodeItem.model=angular.copy(childmodel.model),listNodeItem.lengthModels+=1),"ListNode"===childmodel.schema.formType){var reformattedModel={};angular.forEach(childmodel.model,function(value,key){key.indexOf("_id")>-1?angular.forEach(childmodel.form,function(v,k){function indexInTitleMap(element,index,array){return element.value===value?element:void 0}v.formName===key&&(reformattedModel[key]={key:value,unicode:v.titleMap.find(indexInTitleMap).name})}):reformattedModel[key]={key:key,unicode:Generator.item_from_array(value,childmodel.schema.properties[key].titleMap)}}),childmodel.edit?(listNodeItem.model[childmodel.edit]=childmodel.model,Object.keys(reformattedModel).length>0?listNodeItem.items[childmodel.edit]=reformattedModel:listNodeItem.items[childmodel.edit]=angular.copy(childmodel.model)):(listNodeItem.model.push(angular.copy(childmodel.model)),Object.keys(reformattedModel).length>0?listNodeItem.items.push(reformattedModel):listNodeItem.items.push(angular.copy(childmodel.model))),listNodeItem.lengthModels+=1}})})}}}).directive("addModalForLinkedModel",function($uibModal,$rootScope,$route,Generator){return{link:function(scope,element,attributes){element.on("click",function(){var modalInstance=$uibModal.open({animation:!0,backdrop:"static",keyboard:!1,templateUrl:"shared/templates/linkedModelModalContent.html",controller:"ModalController",size:"lg",resolve:{items:function(){var formName=attributes.addModalForLinkedModel;return Generator.get_form({form_params:{wf:scope.form.wf,model:scope.form.model_name,cmd:scope.form.add_cmd},modalElements:{buttonPositions:{bottom:"move-to-bottom-modal",top:"move-to-top-modal",none:""},workOnForm:"linkedModelForm",workOnDiv:"-modal"+formName},submitModalForm:function(){$rootScope.$broadcast("submitModalForm")},validateModalDate:function(field){$rootScope.$broadcast("validateModalDate",field)},formName:formName})}}});modalInstance.result.then(function(childscope,key){var formName=childscope.formName;Generator.submit(childscope,!1).success(function(data){scope.model[formName]=data.forms.model.object_key,scope.form.titleMap.push({value:data.forms.model.object_key,name:data.forms.model.unicode}),scope.form.selected_item={value:data.forms.model.object_key,name:data.forms.model.unicode},scope.$watch(document.querySelector("input[name="+scope.form.model_name+"]"),function(){angular.element(document.querySelector("input[name="+scope.form.model_name+"]")).val(scope.form.selected_item.name)})})})})}}}).directive("modalFormLocator",function(){return{link:function(scope){scope.$emit("modalFormLocator")}}}),angular.module("ulakbus").factory("FormConstraints",function($q,$log,$timeout){var cond=function(condition){return!condition},cond_generator=function(){return{lt:function(a,b){return!(b>a)},gt:function(a,b){return!(a>b)}}},cond_multiple=function(val1,val2,condition){var valid=!0;return angular.forEach(val2,function(value,key){inputval=angular.element(document.querySelector("#"+value)).val(),cond_generator()[condition](val1,inputval)&&(valid=!1)}),valid},fo_co={};return fo_co.lt=function(value,ref_val,input_name){return cond(value>ref_val)},fo_co.lt_date=function(value,ref_val,input_name){return cond(value>ref_val)},fo_co.ltm=function(value,ref_vals,input_name){return cond_multiple(value,ref_vals,"lt")},fo_co.gt=function(value,ref_val,input_name){return cond(ref_val>value)},fo_co.gt_date=function(value,ref_val,input_name){return cond(ref_val>value)},fo_co.gtm=function(value,ref_vals,input_name){return cond_multiple(value,ref_vals,"gt")},fo_co.selectbox_fields=function(value,fields,input_name){var form_items=angular.element(document.querySelectorAll("bootstrap-decorator"));angular.forEach(form_items,function(v,k){angular.element(v).removeClass("hide");var checkpoint;try{checkpoint=angular.isDefined(v.querySelector("input"))&&null!==v.querySelector("input")?v.querySelector("input").name:v.querySelector("select").name,checkpoint!==input_name[0]&&checkpoint!==fields[value][0]&&(angular.element(v).addClass("hide"),$log.debug(checkpoint,fields[value],angular.isDefined(fields[checkpoint])))}catch(e){$log.error(e.message)}})},fo_co}),angular.module("ulakbus").factory("ErrorService",function(toastr,$rootScope,$location,$log){var error_service={};return error_service.handle=function(rejection,prtcl){var errorInModal;"http"===prtcl&&(errorInModal=rejection.data?"error"in rejection.data:!1),"ws"===prtcl&&(rejection.status=rejection.status||rejection.code,rejection.data={error:rejection.error,title:rejection.title},errorInModal=!0);var errorModal=function(){if(0===$rootScope.loginAttempt&&"http"===prtcl)return void $log.debug("not logged in, no alert message triggered");var codefield="";if(rejection.data.error&&(codefield="<p><pre>"+rejection.data.error+"</pre></p>"),
$('<div class="modal"><div class="modal-dialog" style="width:100%;" role="document"><div class="modal-content"><div class="modal-header"><button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button><h4 class="modal-title" id="exampleModalLabel">Error Status: '+rejection.status+"<br>Error Title: "+rejection.data.title+'</h4></div><div class="modal-body"><div class="alert alert-danger"><strong>'+rejection.data.description+"</strong>"+codefield+'</div></div><div class="modal-footer"><button type="button" class="btn btn-default" data-dismiss="modal">Kapat</button></div></div></div></div>').modal(),!rejection.no_highlight)try{$("pre:not(.hljs)").each(function(i,block){hljs.highlightBlock(block)})}catch(e){$log.debug("Exception: ",e.message)}},errorInAlertBox=function(alertContent){errorInModal?errorModal():$rootScope.loginAttempt>0&&toastr.error(alertContent.msg,alertContent.title)},errorForAlertBox={title:rejection.status,msg:rejection.data?rejection.data.description:"Error",type:"error"},errorDispatch={"-1":function(){$log.error("-1 returned:",rejection)},400:function(){$location.reload()},401:function(){return"/login"!==$location.path()?window.location.reload():void $log.debug("show errors on login form")},403:function(){rejection.data.is_login===!0&&($rootScope.loggedInUser=!0,"/login"===$location.path()&&$location.path("/dashboard"))},404:function(){errorInAlertBox(errorForAlertBox)},500:function(){errorInAlertBox(errorForAlertBox)},503:function(){rejection.data={description:"Servise erişilemiyor."},errorInAlertBox(errorForAlertBox)}};errorDispatch[rejection.status||rejection.code]()},error_service}),angular.module("ulakbus").controller("KeyListenController",function($scope,action_service){$scope.keylog=[0,1],$scope.down=function(e){angular.forEach(action_service.combinations,function(value,key){action_service.equal(value,$scope.keylog.concat([e.keyCode]))&&action_service.acts[key]()}),$scope.keylog.shift(),$scope.keylog.push(e.keyCode)},$scope.$on("user_ready",function(){$scope.user_ready=!0}),$scope.user_ready=!1}).factory("action_service",function($uibModal,$log){var actions={};return actions.equal=function(a,b){return!(b>a||a>b)},actions.combinations={open_inspector:[91,16,75]},actions.acts={open_inspector:function(){var modalInstance=$uibModal.open({animation:!0,templateUrl:"shared/templates/actionsModalContent.html",controller:"ActionsModalController",resolve:{items:function(){return document.querySelectorAll(".navbar-collapse a, #side-user-menu a, .dropdown-menu li a")}}});modalInstance.result.then(function(selectedItem){$log.info("resirect to:",selectedItem),location.hash=selectedItem.value})}},actions}).controller("ActionsModalController",function($scope,$uibModalInstance,items){$scope.actions=[],angular.forEach(items,function(value,key){value.children[1]||$scope.actions.push({name:value.innerHTML,value:value.hash})}),$scope.doThis=function(item){$uibModalInstance.close(item)},$scope.cancel=function(){$uibModalInstance.dismiss("cancel")}}),angular.module("ulakbus").service("WSUri",function(RESTURL){var base=RESTURL.url.replace("http","ws");return{url:base+"ws"}}).factory("WSOps",function(WSUri,$q,$log,$rootScope,$timeout,$document,ErrorService,WS,IsOnline,DevSettings){$rootScope.$on("ws_turn_on",function(){generate_ws()});var websocket,refresh_count=0,refresh_websocket=5>refresh_count?1e3:5e3,isSupported=function(){return"WebSocket"in window},generate_ws=function(){if(isSupported())$log.info("Openning web socket..."),websocket=new WS(WSUri.url),websocket.onopen=function(evt){wsOps.onOpen(evt),refresh_count=0},websocket.onclose=function(evt){wsOps.onClose(evt),wsOps.loggedOut!==!0&&$timeout(function(){generate_ws(),refresh_count+=1},refresh_websocket)},websocket.onmessage=function(evt){wsOps.onMessage(evt)},websocket.onerror=function(evt){wsOps.onError(evt)};else{var error={error:"Tarayıcınız websocket desteklememektedir. Lütfen güncel bir tarayıcı kullanınız.",code:500,title:"Uyumsuz Tarayıcı",no_highlight:!0};ErrorService.handle(error,"ws")}},wsOps={},pingCounter=0,checkPing=function(){pingCounter>2&&(websocket.close(),$log.debug("websocket not pong"),pingCounter=0)},keepAlivePing=function(interval){return setInterval(function(){$rootScope.websocketIsOpen&&IsOnline.get_status()&&"on"===DevSettings.settings.keepAlive&&(wsOps.doSend(angular.toJson({data:{view:"ping"}})),pingCounter+=1,checkPing())},interval)};wsOps.onOpen=function(evt){$rootScope.websocketIsOpen=!0,$log.info("CONNECTED",evt),keepAlivePing(2e4),wsOps.loggedOut=!1},wsOps.onClose=function(event){$rootScope.websocketIsOpen=!1,$log.info("DISCONNECTED",event)},wsOps.callbacks={},wsOps.onMessage=function(event){var msg_methods={init:function(data){if(angular.isDefined(wsOps.callbacks[data.callbackID])){var callback=wsOps.callbacks[data.callbackID];delete wsOps.callbacks[data.callbackID],callback.resolve(data)}else $log.info("Data without callback: %o",data),"pong"===msg_data.msg&&(pingCounter-=1)},error:function(){return ErrorService.handle(msg_data,"ws")},notification:function(){$rootScope.$broadcast("notifications",msg_data.notifications)},dashboard:function(){var callback=wsOps.callbacks[msg_data.callbackID];delete wsOps.callbacks[msg_data.callbackID],callback.resolve(msg_data)},task_list:function(){$rootScope.$broadcast("task_list",msg_data.task_list)}},do_action=function(options){var args=[].slice.call(arguments,0),action="init";return"function"==typeof msg_methods[args[1]]&&(action=args[1],args.shift()),msg_methods[action](args[0])},msg_data=angular.fromJson(event.data);msg_data.error&&(msg_data.cmd="error"),do_action(msg_data,msg_data.cmd),$log.info("MESSAGE:",event,"Data:",JSON.parse(event.data))},wsOps.onError=function(evt){$log.error("ERROR :: "+evt)},wsOps.doSend=function(data){websocket.send(data),$log.info("SENT:",data)},wsOps.request=function(data){if($rootScope.websocketIsOpen){var request={callbackID:Math.random().toString(36).substring(7),data:data},deferred=$q.defer();return wsOps.callbacks[request.callbackID]=deferred,websocket.send(angular.toJson(request)),$log.info("SENT:",data),deferred.promise.then(function(response){return request.response=response,response})}$timeout(function(){wsOps.request(data)},1e3)},wsOps.close=function(){wsOps.loggedOut=!0,websocket.close(),$log.info("CLOSED")};var mask=angular.element('<div class="body-mask"><div class="loader"></div></div>');mask.css({zIndex:"2010",opacity:"0.6"});$document.find("body").eq(0);return wsOps}),angular.module("ulakbus").directive("logout",function($http,$location,RESTURL,AuthService){return{link:function($scope,$element,$rootScope){$element.on("click",function(){AuthService.logout()})}}}).directive("headerNotification",function(WSOps,$rootScope,$cookies,$interval,RESTURL,$uibModal){return{templateUrl:"shared/templates/directives/header-notification.html",restrict:"E",replace:!0,scope:{},controller:function($scope){$scope.notifications={1:[],2:[],3:[],4:[]},$scope.popModal=function(item){var modalInstance=$uibModal.open({animation:!0,templateUrl:"shared/templates/notificationsModalContent.html",controller:function($scope){$scope.notification=item,$scope.cancel=function(){modalInstance.dismiss("cancel")}},size:"lg"})},$scope.groupNotifications=function(notifications){$scope.notifications={1:[],2:[],3:[],4:[]},angular.forEach(notifications,function(value,key){$scope.notifications[value.type].push(value)}),$scope.$apply()},$scope.$on("notifications",function(event,data){$scope.groupNotifications(data)}),$scope.markAsRead=function(event,item,group,index){return event.stopPropagation(),WSOps.doSend(angular.toJson({data:{view:"notify",id:item.id}})),$scope.notifications[group].splice(index,1),$event.preventDefault(),$event.stopPropagation(),!1}}}}).directive("searchDirective",function(Generator,$log,$rootScope){return{templateUrl:"shared/templates/directives/search.html",restrict:"E",replace:!0,link:function($scope){$scope.searchForm=[{key:"searchbox",htmlClass:"pull-left"},{type:"submit",title:"Ara",style:"btn-info",htmlClass:"pull-left"}],$scope.searchSchema={type:"object",properties:{searchbox:{type:"string",minLength:2,title:"Ara","x-schema-form":{placeholder:"Arama kriteri giriniz..."}}},required:[]},$scope.searchModel={searchbox:""},$scope.searchSubmit=function(form){if($scope.$broadcast("schemaFormValidate"),form.$valid){var searchparams={token:$scope.$parent.token,object_id:$scope.$parent.object_id,form_params:{wf:$scope.$parent.wf,model:$scope.$parent.form_params.model,cmd:$scope.$parent.reload_cmd,flow:$scope.$parent.form_params.flow,query:$scope.searchModel.searchbox}};Generator.submit(searchparams)}}}}}).directive("sortDirective",function(Generator,$log){return{templateUrl:"shared/templates/directives/sort.html",restrict:"E",replace:!0,link:function($scope){$scope.titleMap=[{value:"artan",name:"Artan"},{value:"azalan",name:"Azalan"}],$scope.sortForm=[{key:"sortbox",htmlClass:"pull-left",type:"select",titleMap:$scope.titleMap},{type:"submit",title:"Sırala",htmlClass:"pull-left"}],$scope.sortSchema={type:"object",properties:{sortbox:{type:"select",title:"Sırala"}},required:["sortbox"]},$scope.sortModel={sortbox:""},$scope.sortSubmit=function(form){if($scope.$broadcast("schemaFormValidate"),form.$valid){var sortparams={url:$scope.wf,token:$scope.$parent.token,object_id:$scope.$parent.object_id,form_params:{model:$scope.$parent.form_params.model,cmd:$scope.$parent.reload_cmd,flow:$scope.$parent.form_params.flow,param:"sort",id:$scope.sortModel.sortbox}};Generator.submit(sortparams)}}}}}).directive("collapseMenu",function($timeout,$window,$cookies){return{templateUrl:"shared/templates/directives/menuCollapse.html",restrict:"E",replace:!0,scope:{},controller:function($scope,$rootScope){$rootScope.collapsed=!1,$rootScope.sidebarPinned=$cookies.get("sidebarPinned")||1,$scope.collapseToggle=function(){$window.innerWidth>"768"&&($rootScope.collapsed===!1?(jQuery(".sidebar").css("width","62px"),jQuery(".manager-view").css("width","calc(100% - 62px)"),$rootScope.collapsed=!0,$rootScope.sidebarPinned=0,$cookies.put("sidebarPinned",0)):(jQuery("span.menu-text, span.arrow, .sidebar footer").fadeIn(400),jQuery(".sidebar").css("width","250px"),jQuery(".manager-view").css("width","calc(100% - 250px)"),$rootScope.collapsed=!1,$rootScope.sidebarPinned=1,$cookies.put("sidebarPinned",1)))},$timeout(function(){"0"===$cookies.get("sidebarPinned")&&$scope.collapseToggle()})}}}).directive("headerSubMenu",function($location){return{templateUrl:"shared/templates/directives/header-sub-menu.html",restrict:"E",replace:!0,link:function($scope){$scope.style="width:calc(100% - 300px);",$scope.$on("$routeChangeStart",function(){$scope.style="/dashboard"===$location.path()?"width:calc(100% - 300px);":"width:%100 !important;"})}}}).directive("headerBreadcrumb",function($location){return{templateUrl:"shared/templates/directives/header-breadcrumb.html",restrict:"E",replace:!1,link:function($scope){$scope.goBack=function(){$location.state()}}}}).directive("sidebar",["$location",function(){return{templateUrl:"shared/templates/directives/sidebar.html",restrict:"E",replace:!0,scope:{},controller:function($scope,$rootScope,$cookies,$route,AuthService,WSOps,RESTURL,$log,$location,$window,$timeout){$scope.prepareMenu=function(menuItems){var newMenuItems={};return angular.forEach(menuItems,function(value,key){angular.forEach(value,function(v,k){newMenuItems[k]=v})}),newMenuItems};var generate_dashboard=function(){if($rootScope.current_user===!0)if($rootScope.websocketIsOpen){var sidebarmenu=$("#side-menu");sidebarmenu.metisMenu(),WSOps.request({view:"dashboard"}).then(function(data){function reGroupMenuItems(items,baseCategory){var newItems={};return angular.forEach(items,function(value,key){newItems[value.kategori]=newItems[value.kategori]||[],newItems[value.kategori].push(value)}),newItems}$scope.allMenuItems=angular.copy(data),angular.forEach($scope.allMenuItems,function(value,key){"current_user"!==key&&"settings"!==key&&($scope.allMenuItems[key]=reGroupMenuItems(value,key))}),$rootScope.quick_menu=reGroupMenuItems(data.quick_menu,"quick_menus"),$rootScope.quick_menu=data.quick_menu,delete data.quick_menu,$log.debug("quick menu",$rootScope.quick_menu),$rootScope.$broadcast("authz",data),$rootScope.searchInputs=data,data.current_user,$rootScope.current_user=data.current_user,(data.ogrenci||data.personel)&&($rootScope.current_user.can_search=!0),$rootScope.settings=data.settings,$scope.menuItems=$scope.prepareMenu({other:$scope.allMenuItems.other}),$timeout(function(){sidebarmenu.metisMenu()})})}else $timeout(function(){generate_dashboard()},500)};$scope.$on("generate_dashboard",function(){generate_dashboard()}),$scope.$on("menuitems",function(event,data){var menu={};menu[data]=$scope.allMenuItems[data],$rootScope.$broadcast("usermenuitems",$scope.prepareMenu(menu))}),$scope.$on("selectedUser",function($event,data){$scope.selectedUser=data}),$scope.deselectUser=function(){delete $scope.selectedUser,delete $scope.selectedMenuItems},$rootScope.$watch(function($rootScope){return $rootScope.section},function(newindex,oldindex){newindex>-1&&($scope.menuItems=[$scope.allMenuItems[newindex]],$scope.collapseVar=0)}),$scope.selectedMenu=$location.path(),$scope.collapseVar=0,$scope.multiCollapseVar=0,$scope.check=function(x){x===$scope.collapseVar?$scope.collapseVar=0:$scope.collapseVar=x},$scope.breadcrumb=function(itemlist,$event){$rootScope.breadcrumblinks=itemlist},$scope.multiCheck=function(y){y===$scope.multiCollapseVar?$scope.multiCollapseVar=0:$scope.multiCollapseVar=y}}}}]).directive("rightSidebar",["$location",function(){return{templateUrl:"shared/templates/directives/right-sidebar.html",restrict:"E",replace:!0,scope:{},controller:function($scope,$rootScope,$cookies,$route,$http,RESTURL,$log,$location,$window,$timeout){var sidebarUserMenu=$("#side-user-menu");sidebarUserMenu.metisMenu(),$scope.$on("usermenuitems",function(event,data){$scope.selectedMenuItems=data,$timeout(function(){sidebarUserMenu.metisMenu()}),jQuery(".right-sidebar").css("width","300px"),jQuery(".manager-view-inner").css("width","calc(100% - 300px)")}),$scope.$on("selectedUser",function($event,data){$scope.selectedUser=data}),$scope.deselectUser=function(){jQuery(".right-sidebar").css("width","0px"),jQuery(".manager-view-inner").css("width",""),delete $scope.selectedUser,delete $scope.selectedMenuItems},$rootScope.$watch(function($rootScope){return $rootScope.section},function(newindex,oldindex){newindex>-1&&($scope.menuItems=[$scope.allMenuItems[newindex]],$scope.collapseVar=0)}),$scope.selectedMenu=$location.path(),$scope.collapseVar=0,$scope.multiCollapseVar=0,$scope.check=function(x){x===$scope.collapseVar?$scope.collapseVar=0:$scope.collapseVar=x},$scope.multiCheck=function(y){y===$scope.multiCollapseVar?$scope.multiCollapseVar=0:$scope.multiCollapseVar=y}}}}]).directive("stats",function(){return{templateUrl:"shared/templates/directives/stats.html",restrict:"E",replace:!0,scope:{model:"=",comments:"@",number:"@",name:"@",colour:"@",details:"@",type:"@","goto":"@"}}}).directive("notifications",function(){return{templateUrl:"shared/templates/directives/notifications.html",restrict:"E",replace:!0}}).directive("msgbox",function(){return{templateUrl:"shared/templates/directives/msgbox.html",restrict:"E",replace:!1}}).directive("alertBox",function($timeout){return{templateUrl:"shared/templates/directives/alert.html",restrict:"E",replace:!0,link:function($scope){$scope.$on("alertBox",function($event,data){$timeout(function(){delete $scope.alerts},5e3),$scope.alerts=[data]})}}}).directive("sidebarSearch",function(){return{templateUrl:"shared/templates/directives/sidebar-search.html",restrict:"E",replace:!0,scope:{},controller:function($scope){$scope.selectedMenu="home"}}}).directive("fileread",function($timeout){return{scope:{fileread:"="},link:function(scope,element,attributes){element.bind("change",function(changeEvent){var reader=new FileReader;reader.onload=function(loadEvent){scope.$apply(function(){scope.fileread=loadEvent.target.result}),$timeout(function(){scope.$parent.model[changeEvent.target.name]={file_name:changeEvent.target.files[0].name,file_content:scope.$parent.model[changeEvent.target.name]},document.querySelector("#image-preview").src=URL.createObjectURL(changeEvent.target.files[0])})},reader.readAsDataURL(changeEvent.target.files[0])})}}}),angular.module("ulakbus.auth",["ngRoute","ngCookies"]).controller("LoginController",function($scope,$q,$timeout,$location,$routeParams,$rootScope,$log,WSOps,Generator,AuthService){$scope.url="login",$scope.form_params={},$scope.form_params.clear_wf=1;try{WSOps.close()}catch(e){$log.error(e.message)}AuthService.get_form($scope).then(function(data){data.login&&$location.path("/"),$scope.form=[{key:"username",type:"string",title:"Kullanıcı Adı"},{key:"password",type:"password",title:"Şifre"},{type:"submit",title:"Giriş Yap"}]}),$scope.loggingIn=!1,$scope.onSubmit=function(form){$scope.$broadcast("schemaFormValidate"),form.$valid?($scope.loggingIn=!0,$rootScope.loginAttempt=1,Generator.button_switch(!1),AuthService.login($scope.url,$scope.model).success(function(data){$scope.message=data.title,$scope.loggingIn=!1}).error(function(data){$scope.message=data.title,$scope.loggingIn=!1}).then(function(){$scope.loggingIn=!1,Generator.button_switch(!0)})):$log.debug("not valid")},$log.debug("login attempt: ",$rootScope.loginAttempt)}),angular.module("ulakbus.auth").factory("AuthService",function($http,$rootScope,$location,$log,$route,Generator,RESTURL,WSOps){var authService={};return authService.get_form=function(scope){return $http.post(Generator.makeUrl(scope),scope.form_params).success(function(data,status,headers,config){return"upgrade"===data.cmd?($rootScope.loggedInUser=!0,$rootScope.$broadcast("user_ready"),$rootScope.$broadcast("ws_turn_on"),$location.path("/dashboard")):"retry"!==data.cmd?(angular.isDefined(data.forms)&&"/login"!==$location.path()&&$location.path("/login"),Generator.generate(scope,data)):void $location.path("/login")})},authService.login=function(url,credentials){return credentials.cmd="do",$http.post(RESTURL.url+url,credentials).success(function(data,status,headers,config){return Generator.button_switch(!0),"upgrade"===data.cmd&&($rootScope.loggedInUser=!0,$rootScope.$broadcast("user_ready"),$rootScope.$broadcast("ws_turn_on"),$location.path("/dashboard")),403===data.status_code?(data.title="İşlem başarısız oldu. Lütfen girdiğiniz bilgileri kontrol ediniz.",data):void 0}).error(function(data,status,headers,config){return data.title="İşlem başarısız oldu. Lütfen girdiğiniz bilgileri kontrol ediniz.",data})},authService.logout=function(){$rootScope.loginAttempt=0,WSOps.request({wf:"logout"}).then(function(data){$rootScope.loggedInUser=!1,$rootScope.current_user=!0,$log.debug("loggedout"),$location.path("/login"),WSOps.close()})},authService.check_auth=function(){var post_data={url:"login",form_params:{}};return authService.get_form(post_data)},authService}),angular.module("ulakbus.dashboard",[]).config(function($uibTooltipProvider){$uibTooltipProvider.setTriggers({click:"mouseleave"})}).controller("DashController",function($scope,$rootScope,$routeParams,$route,$timeout,$http,$cookies,RESTURL,Generator,WSOps){$rootScope.$broadcast("generate_dashboard"),$scope.section=function(section_index){$rootScope.section=section_index},$scope.$on("authz",function(event,data){$rootScope.searchInputs=data}),$scope.keyword={student:"",staff:""},$scope.students=[],$scope.staffs=[],$scope.search=function(where){($scope.keyword.staff.length>2||$scope.keyword.student.length>2)&&$timeout(function(){"personel"===where&&$scope.getItems(where,$scope.keyword.staff).then(function(data){$scope.staffs=data.results}),"ogrenci"===where&&$scope.getItems(where,$scope.keyword.student).then(function(data){$scope.students=data.results})},500)},$scope.getItems=function(where,what){return $scope.showResults=!0,WSOps.request({view:where+"_ara",query:what})},$scope.userPopover={templateUrl:"components/dashboard/user-info.html"},$scope.get_info=function(type,key){Generator.get_list({url:"crud",form_params:{wf:"crud",model:type,object_id:key,cmd:"show"}}).then(function(data){$scope.userPopover.name=data.object.Ad+" "+data.object.Soyad,$scope.userPopover.tcno=data.object["TC Kimlik No"],$scope.userPopover.image=data.object.Avatar||"img/sample-profile-pic.jpg"})},$scope.select=function(who,type){$rootScope.$broadcast("selectedUser",{name:who[0],tcno:who[1],key:who[2]}),$rootScope.$broadcast("menuitems",type),$scope.showResults=!1},$scope.$on("notifications",function(event,data){$scope.notifications=data}),$scope.$on("selectedUser",function($event,data){$scope.selectedUser=data}),$scope.deselectUser=function(){delete $scope.selectedUser,delete $scope.selectedMenuItems},$scope.markAsRead=function(items){$rootScope.$broadcast("markasread",items)}}),angular.module("ulakbus.crud",["schemaForm","ui.bootstrap","ulakbus.formService"]).config(function(sfErrorMessageProvider){sfErrorMessageProvider.setDefaultMessage(302,"Bu alan zorunludur."),sfErrorMessageProvider.setDefaultMessage(200,"En az {{schema.minLength}} değer giriniz."),sfErrorMessageProvider.setDefaultMessage(201,"En fazla {{schema.minLength}} değer giriniz.")}).service("CrudUtility",function($log,$rootScope){return{generateParam:function(scope,routeParams,cmd){return scope.url=routeParams.wf,angular.forEach(routeParams,function(value,key){key.indexOf("_id")>-1&&"param_id"!==key&&(scope.param=key,scope.param_id=value)}),scope.form_params={model:routeParams.model,param:scope.param||routeParams.param,id:scope.param_id||routeParams.param_id,wf:routeParams.wf,object_id:routeParams.key,filters:{}},scope.param_id&&(scope.form_params.filters[scope.param]={values:[scope.param_id],type:"check"}),scope.model=scope.form_params.model,scope.wf=scope.form_params.wf,scope.param=scope.form_params.param,scope.param_id=scope.form_params.id,scope},listPageItems:function(scope,pageData){angular.forEach(pageData,function(value,key){scope[key]=value}),scope.meta.selective_listing===!0?angular.forEach(scope.objects,function(_v,_k){angular.forEach(_v.objects,function(value,key){if(_v.selected===!0&&(scope.selected_key=_k),key>0){var linkIndexes={};angular.forEach(value.actions,function(v,k){"link"===v.show_as&&(linkIndexes=v)}),angular.forEach(value.fields,function(v,k){try{value.actions.length>0&&linkIndexes.fields?scope.objects[_k][key].fields[k]={type:linkIndexes.fields.indexOf(k)>-1?"link":"str",content:v,cmd:linkIndexes.cmd,mode:linkIndexes.mode}:scope.objects[_k].objects[key].fields[k]={type:"str",content:v}}catch(e){$log.error(e),scope.objects[_k].objects[key].fields[k]={type:"str",content:v}}})}})}):angular.forEach(scope.objects,function(value,key){if(key>0){var linkIndexes={};angular.forEach(value.actions,function(v,k){"link"===v.show_as&&(linkIndexes=v)}),angular.forEach(value.fields,function(v,k){value.actions.length>0&&linkIndexes.fields?scope.objects[key].fields[k]={type:linkIndexes.fields.indexOf(k)>-1?"link":"str",content:v,cmd:linkIndexes.cmd,mode:linkIndexes.mode}:scope.objects[key].fields[k]={type:"str",content:v}})}}),$log.debug(scope.objects)}}}).controller("CRUDController",function($scope,$routeParams,$location,Generator,CrudUtility){return $location.url().indexOf("?=")>0?$location.url($location.url().replace("?=","")):(CrudUtility.generateParam($scope,$routeParams),void Generator.get_wf($scope))}).controller("CRUDListFormController",function($scope,$rootScope,$location,$sce,$http,$log,$uibModal,$timeout,Generator,$routeParams,CrudUtility){$scope.show_crud=!1,$scope.$on("$viewContentLoaded",function(){$timeout(function(){$scope.show_crud=!0},500)}),$scope.wf_step=$routeParams.step,$scope.paginate=function(reloadData){$scope.form_params.cmd=$scope.reload_cmd,$scope.form_params=angular.extend($scope.form_params,reloadData),$log.debug("reload data",$scope),Generator.get_wf($scope)},$scope.$on("reload_cmd",function(event,data){$scope.reload_cmd=data,$scope.reloadCmd()}),$scope.$on("updateObjects",function($event,data){$scope.objects=data,CrudUtility.listPageItems($scope,{objects:$scope.objects})}),$scope.$on("formLocator",function(event){$scope.formgenerated=event.targetScope.formgenerated}),$scope.remove=function(item,type,index){$scope[type][item.title].model.splice(index,1),$scope[type][item.title].items.splice(index,1)},$scope.onSubmit=function(form){$scope.$broadcast("schemaFormValidate"),form.$valid&&Generator.submit($scope)},$scope.do_action=function(key,todo){Generator.doItemAction($scope,key,todo,todo.mode||"normal")},$scope.getNumber=function(num){return new Array(num)},$scope.markdownWorkaround=function(value){return value.replace("\n","<br>")},$scope.datepickerstatuses={},$scope.inline_datepicker_status=function(field){return $scope.datepickerstatuses[field]||!1},$scope.openDatepicker=function(field){$scope.datepickerstatuses[field]=!0},$scope.createListObjects=function(){$scope.object.constructor===Array?$log.debug("new type show object"):$scope.object.type?$scope.object=[$scope.object]:$scope.object=[{type:"table",fields:angular.copy($scope.object)}]},$scope.showCmd=function(){CrudUtility.generateParam($scope,$routeParams,$routeParams.cmd);var pageData=Generator.getPageData();pageData.pageData===!0?($scope.object=pageData.object,Generator.setPageData({pageData:!1})):Generator.get_wf($scope).then(function(res){$scope.object=res.data.object,$scope.model=$routeParams.model}),$scope.createListObjects()},$scope.update_selective_list=function(key){$scope.objects=key.objects},$scope.listFormCmd=function(){var setpageobjects=function(data){CrudUtility.listPageItems($scope,data),Generator.generate($scope,data),Generator.setPageData({pageData:!1})},pageData=Generator.getPageData();pageData.pageData===!0&&($log.debug("pagedata",pageData.pageData),CrudUtility.generateParam($scope,pageData,$routeParams.cmd),setpageobjects(pageData,pageData),$scope.second_client_cmd&&$scope.createListObjects()),void 0!==pageData.pageData&&pageData.pageData!==!1||(CrudUtility.generateParam($scope,$routeParams,$routeParams.cmd),Generator.get_wf($scope)),$scope.object&&$scope.createListObjects(),angular.isDefined($scope.meta.selective_listing)&&($scope.all_objects=angular.copy($scope.objects),$scope.selective_list_key=$scope.all_objects[$scope.selected_key],$scope.objects=$scope.selective_list_key.objects)},$scope.reloadCmd=function(){var pageData=Generator.getPageData();CrudUtility.generateParam($scope,pageData,$routeParams.cmd),$log.debug("reload data",$scope),Generator.get_wf($scope)},$scope.resetCmd=function(){var pageData=Generator.getPageData();CrudUtility.generateParam($scope,pageData,$routeParams.cmd),delete $scope.token,delete $scope.filters,delete $scope.cmd,Generator.get_wf($scope)};var executeCmd={show:$scope.showCmd,list:$scope.listFormCmd,form:$scope.listFormCmd,reload:$scope.reloadCmd,reset:$scope.resetCmd};return executeCmd[$routeParams.cmd]()}).directive("crudListDirective",function(){return{templateUrl:"components/crud/templates/list.html",restrict:"E",replace:!0}}).directive("crudFormDirective",function(){return{templateUrl:"components/crud/templates/form.html",restrict:"E",replace:!0}}).directive("crudShowDirective",function(){return{templateUrl:"components/crud/templates/show.html",restrict:"E",replace:!0}}).directive("formLocator",function(){return{link:function(scope){scope.$emit("formLocator")}}}).directive("crudFilters",function(Generator){return{templateUrl:"components/crud/templates/filter.html",restrict:"E",replace:!0,link:function($scope){$scope.form_params.filters=$scope.form_params.filters||{},$scope.form_params.token=$scope.token,$scope.filterList={},$scope.filterCollapsed={},$scope.$watch("list_filters",function(){angular.forEach($scope.list_filters,function(value,key){$scope.filterList[value.field]={values:value.values||[],type:value.type},$scope.filterCollapsed[value.field]=Object.keys($scope.filterCollapsed).length>0})}),$scope.collapseFilter=function(field){$scope.filterCollapsed[field]=!$scope.filterCollapsed[field]},$scope.status={startOpened:!1,endOpened:!1},$scope.dateFilterOpen=function($event,which){this.status[which]=!0},$scope.format="dd.MM.yyyy",$scope.filterSubmit=function(){angular.forEach($scope.filterList,function(value,key){if(value.model)if("date"===value.type){var dateValues=[null,null];angular.forEach(value.model,function(v,k){dateValues[k]=Generator.dateformatter(v)}),$scope.form_params.filters[key]={values:dateValues,type:value.type}}else $scope.form_params.filters[key]={values:Object.keys(value.model),type:value.type||"check"}}),Generator.get_wf($scope)}}}}),angular.module("ulakbus.crud").directive("quickAdd",function(Generator){return{templateUrl:"components/crud/templates/quick_add.html",restrict:"E",replace:!0,scope:{node:"="},controller:function($scope){$scope.kw="",$scope.getTitleMap=function(){return $scope.generateTitleMap($scope.kw)},$scope.generateTitleMap=function(kw){var searchData={form_params:{view:$scope.node.quick_add_view,model:$scope.node.quick_add_model,query:kw}};return angular.isDefined($scope.$parent.form_params.param)&&(searchData.form_params.id=$scope.$parent.form_params.id),Generator.get_list(searchData).then(function(res){var titleMap=[];return angular.forEach(res.objects,function(item){titleMap.push({value:item[0],name:item[1]})}),titleMap})},$scope.onSelect=function(item){var get_first_key=function(){return Object.keys($scope.node.schema.properties)[0]},field=$scope.node.quick_add_field||get_first_key(),f={key:item.value};f[field]=item.name,angular.forEach($scope.node.items[0],function(value,key){angular.isDefined(f[key])||(f[key]=void 0)});try{angular.forEach($scope.node.items,function(value,key){if(value.key===item.value)throw Error()}),$scope.node.model.push(f),$scope.node.items.push(f)}catch(e){alert("bu öğe listede zaten mevcut!!")}}}}}),angular.module("ulakbus.debug",["ngRoute"]).controller("DebugController",function($scope,$rootScope,$location){$scope.debug_queries=$rootScope.debug_queries}),angular.module("ulakbus").factory("DevSettings",function($cookies){var devSettings={};return devSettings.settings={keepAlive:$cookies.get("keepAlive")||"on"},devSettings}),angular.module("ulakbus.devSettings",["ngRoute"]).controller("DevSettingsController",function($scope,$cookies,$rootScope,RESTURL,DevSettings){$scope.backendurl=$cookies.get("backendurl"),$scope.keepAlive=$cookies.get("keepAlive")||"on",$scope.changeSettings=function(what,set){document.cookie=what+"="+set,$scope[what]=set,$rootScope.$broadcast(what,set)},$scope.switchOnOff=function(pinn){return"on"==pinn?"off":"on"},$scope.setbackendurl=function(){$scope.changeSettings("backendurl",$scope.backendurl),RESTURL.url=$scope.backendurl},$scope.setKeepAlive=function(){$scope.changeSettings("keepAlive",$scope.switchOnOff($scope.keepAlive)),DevSettings.settings.keepAlive=$cookies.get("keepAlive")}}),angular.module("ulakbus").config(["$routeProvider",function($routeProvider){$routeProvider.when("/error/500",{templateUrl:"components/error_pages/500.html",controller:"500Controller"}).when("/error/404",{templateUrl:"components/error_pages/404.html",controller:"404Controller"})}]),angular.module("ulakbus.error_pages",["ngRoute"]).controller("500Controller",function($scope,$rootScope,$location){}).controller("404Controller",function($scope,$rootScope,$location){}),angular.module("ulakbus.version",["ulakbus.version.interpolate-filter","ulakbus.version.version-directive"]).value("version","0.1.1"),angular.module("ulakbus.version.interpolate-filter",[]).filter("interpolate",["version",function(version){return function(text){return String(text).replace(/\%VERSION\%/gm,version)}}]),angular.module("ulakbus.version.version-directive",[]).directive("appVersion",["version",function(version){return function(scope,elm,attrs){elm.text(version)}}]);