/*! ulakbus-ui  2015-11-04 */
"use strict";var app=angular.module("ulakbus",["ui.bootstrap","angular-loading-bar","ngRoute","ngSanitize","ngCookies","general","formService","ulakbus.dashboard","ulakbus.auth","ulakbus.error_pages","ulakbus.crud","ulakbus.wf","ulakbus.version","gettext","templates-prod"]).constant("RESTURL",function(){var backendurl="http://api.ulakbus.net/";if(document.cookie.indexOf("backendurl")>-1){var cookiearray=document.cookie.split(";");angular.forEach(cookiearray,function(item){item.indexOf("backendurl")>-1&&(backendurl=item.split("=")[1])})}if(location.href.indexOf("backendurl")>-1){var urlfromqstr=location.href.split("?")[1].split("=")[1];backendurl=decodeURIComponent(urlfromqstr.replace(/\+/g," ")),document.cookie="backendurl="+backendurl,window.location.href=window.location.href.split("?")[0]}return{url:backendurl}}()).constant("USER_ROLES",{all:"*",admin:"admin",student:"student",staff:"staff",dean:"dean"}).constant("AUTH_EVENTS",{loginSuccess:"auth-login-success",loginFailed:"auth-login-failed",logoutSuccess:"auth-logout-success",sessionTimeout:"auth-session-timeout",notAuthenticated:"auth-not-authenticated",notAuthorized:"auth-not-authorized"});app.config(["$routeProvider",function($routeProvider,$route){$routeProvider.when("/login",{templateUrl:"components/auth/login.html",controller:"LoginCtrl"}).when("/dashboard",{templateUrl:"components/dashboard/dashboard.html",controller:"DashCtrl"}).when("/crud/add/:model/:param/:id",{templateUrl:"components/crud/templates/add.html",controller:"CRUDAddEditCtrl"}).when("/crud/edit/:model/:param/:id/:key",{templateUrl:"components/crud/templates/add.html",controller:"CRUDAddEditCtrl"}).when("/crud/:model/:param/:id",{templateUrl:"components/crud/templates/list.html",controller:"CRUDListCtrl"}).when("/crud/detail/:model/:param/:id/:key",{templateUrl:"components/crud/templates/show.html",controller:"CRUDShowCtrl"}).when("/:model/",{templateUrl:"components/wf/templates/add.html",controller:"WFAddEditCtrl"}).otherwise({redirectTo:"/dashboard"})}]).run(function($rootScope){$rootScope.loggedInUser=!0,$rootScope.$on("$routeChangeStart",function(event,next,current){})}).config(["$httpProvider",function($httpProvider){$httpProvider.defaults.withCredentials=!0}]).run(function(gettextCatalog){gettextCatalog.setCurrentLanguage("tr"),gettextCatalog.debug=!0}).config(["cfpLoadingBarProvider",function(cfpLoadingBarProvider){cfpLoadingBarProvider.includeBar=!1,cfpLoadingBarProvider.parentSelector="loaderdiv",cfpLoadingBarProvider.spinnerTemplate='<div class="loader">Loading...</div>'}]),app.config(["$httpProvider",function($httpProvider){$httpProvider.interceptors.push(function($q,$rootScope,$location,$timeout){return{request:function(config){return"POST"===config.method&&(config.headers["Content-Type"]="text/plain"),config},response:function(response){return response.data.is_login===!1&&($rootScope.loggedInUser=response.data.is_login,$location.path("/login")),response.data.is_login===!0&&($rootScope.loggedInUser=!0,"/login"===$location.path()&&$location.path("/dashboard")),response},responseError:function(rejection){return 400===rejection.status&&$location.reload(),401===rejection.status&&($location.path("/login"),"/login"===$location.path()&&console.log("show errors on login form")),403===rejection.status&&rejection.data.is_login===!0&&($rootScope.loggedInUser=!0,"/login"===$location.path()&&$location.path("/dashboard")),404===rejection.status&&(console.log(404),$location.path("/error/404")),500===rejection.status&&($('<div class="modal"><div class="modal-dialog" style="width:1024px;" role="document"><div class="modal-content"><div class="modal-header"><button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button><h4 class="modal-title" id="exampleModalLabel">500 Server Error</h4></div><div class="modal-body"><p><pre>'+rejection.data.error+'</pre></p></div><div class="modal-footer"><button type="button" class="btn btn-default" data-dismiss="modal">Close</button></div></div></div></div>').modal(),$location.path("/error/500")),$q.reject(rejection)}}})}]);var general=angular.module("general",[]);general.factory("FormDiff",function(){var formDiff={};return formDiff.get_diff=function(obj1,obj2){var result={};for(key in obj1)obj2[key]!=obj1[key]&&(result[key]=obj1[key]),"array"==typeof obj2[key]&&"array"==typeof obj1[key]&&(result[key]=arguments.callee(obj1[key],obj2[key])),"object"==typeof obj2[key]&&"object"==typeof obj1[key]&&(result[key]=arguments.callee(obj1[key],obj2[key]));return result},formDiff});var form_generator=angular.module("formService",["general"]);form_generator.factory("Generator",function($http,$q,$timeout,RESTURL,FormDiff,$rootScope){var generator={};return generator.makeUrl=function(scope){var getparams=scope.form_params.param?"?"+scope.form_params.param+"="+scope.form_params.id:"";return RESTURL.url+scope.url+(scope.form_params.model||"")+getparams},generator.generate=function(scope,data){return data.forms?(angular.forEach(data.forms,function(value,key){scope[key]=data.forms[key]}),scope.token=data.token,scope.initialModel=angular.copy(scope.model),generator.prepareFormItems(scope),scope.object_id=scope.form_params.object_id,$rootScope.showSaveButton=!0,scope):scope},generator.group=function(formObject){return formObject},generator.prepareFormItems=function(scope){return angular.forEach(scope.schema.properties,function(v,k){if(k==scope.form_params.param)return scope.model[k]=scope.form_params.id,void scope.form.splice(scope.form.indexOf(k),1);if(("submit"===v.type||"button"===v.type)&&(scope.form[scope.form.indexOf(k)]={type:v.type,title:v.title,onClick:function(){scope.model[v]=1,generator.submit(scope)}}),"date"===v.type&&(v.type="string",scope.model[k]=generator.dateformatter(scope.model[k]),$timeout(function(){jQuery("#"+k).datepicker({changeMonth:!0,changeYear:!0,dateFormat:"dd.mm.yy",onSelect:function(date){scope.model[k]=date}})})),("int"===v.type||"float"===v.type)&&(v.type="number",scope.model[k]=parseInt(scope.model[k])),"text_general"===v.type&&(v.type="string",v["x-schema-form"]={type:"textarea"}),"model"===v.type){var formitem=scope.form[scope.form.indexOf(k)],modelscope={url:scope.url,form_params:{model:v.model_name}};formitem={type:"template",templateUrl:"shared/templates/foreignKey.html",title:v.title,name:v.model_name,model_name:v.model_name,titleMap:generator.get_list(modelscope).then(function(res){formitem.titleMap=[],angular.forEach(res.data.nobjects,function(item){item!==res.data.nobjects[0]&&formitem.titleMap.push({value:item[0],name:item[1]+" "+(item[2]?item[2]:"")+"..."})})}),onSelect:function(item){scope.model[k]=item.value},onDropdownSelect:function(item,inputname){scope.model[k]=item.value,jQuery("input[name="+inputname+"]").val(item.name)}},scope.form[scope.form.indexOf(k)]=formitem}("ListNode"===v.type||"Node"===v.type)&&(scope[v.type]=scope[v.type]||{},scope[v.type][k]={title:v.title,form:[],schema:{properties:{},required:[],title:v.title,type:"object",formType:v.type,model_name:k},url:scope.url},null===scope.model[k]?scope[v.type][k].model="Node"===v.type?{}:[]:scope[v.type][k].model=scope.model[k],angular.forEach(v.schema,function(item){scope[v.type][k].schema.properties[item.name]=item,item.required===!0&&"idx"!==item.name&&scope[v.type][k].schema.required.push(item.name),"idx"===item.name?scope[v.type][k].form.push({type:"string",key:item.name,htmlClass:"hidden"}):scope[v.type][k].form.push(item.name)}),scope[v.type][k].lengthModels=scope.model[k]?1:0)}),console.log(scope.form),scope},generator.dateformatter=function(formObject){var ndate=new Date(formObject);if("Invalid Date"==ndate)return"";var newdatearray=[ndate.getDate(),ndate.getMonth(),ndate.getFullYear()];return newdatearray.join(".")},generator.get_form=function(scope){return $http.post(generator.makeUrl(scope),scope.form_params).then(function(res){return generator.generate(scope,res.data)})},generator.get_list=function(scope){return $http.get(generator.makeUrl(scope)).then(function(res){return res})},generator.get_single_item=function(scope){return $http.post(generator.makeUrl(scope),scope.form_params).then(function(res){return res})},generator.isValidEmail=function(email){var re=/^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$/i;return re.test(email)},generator.isValidTCNo=function(tcno){var re=/^([1-9]{1}[0-9]{9}[0,2,4,6,8]{1})$/i;return re.test(tcno)},generator.asyncValidators={emailNotValid:function(value){var deferred=$q.defer();return $timeout(function(){generator.isValidEmail(value)?deferred.resolve():deferred.reject()},500),deferred.promise},tcNoNotValid:function(value){var deferred=$q.defer();return $timeout(function(){generator.isValidTCNo(value)?deferred.resolve():deferred.reject()},500),deferred.promise}},generator.genericSubmit=function($scope,data){return $http.post(generator.makePostUrl($scope),data)},generator.submit=function($scope){angular.forEach($scope.ListNode,function(value,key){$scope.model[key]=value.model}),angular.forEach($scope.Node,function(value,key){$scope.model[key]=value.model});var data={form:$scope.model,cmd:$scope.form_params.cmd,subcmd:"do_list",model:$scope.form_params.model,token:$scope.token};return $scope.object_id&&(data.object_id=$scope.object_id),$http.post(generator.makeUrl($scope),data).success(function(data){data.forms&&(generator.generate($scope,data),$scope.$broadcast("schemaFormRedraw"))})},generator}),form_generator.controller("ModalCtrl",function($scope,$modalInstance,Generator,items){angular.forEach(items,function(value,key){$scope[key]=items[key]}),Generator.prepareFormItems($scope),$scope.onSubmit=function(form){$scope.$broadcast("schemaFormValidate"),console.log(form.$valid),$modalInstance.close($scope)},$scope.cancel=function(){$modalInstance.dismiss("cancel")}}),form_generator.directive("modalForNodes",function($modal){return{link:function(scope,element,attributes){element.on("click",function(){var modalInstance=$modal.open({animation:!1,templateUrl:"shared/templates/listnodeModalContent.html",controller:"ModalCtrl",size:"lg",resolve:{items:function(){var attribs=attributes.modalForNodes.split(","),node=angular.copy(scope.$parent[attribs[1]][attribs[0]]);return"add"===attribs[2]&&(node.model={}),attribs[3]&&(node.model=node.model[attribs[3]]),node.edit=attribs[3],node}}});modalInstance.result.then(function(childmodel,key){"Node"===childmodel.schema.formType&&(scope.$parent[childmodel.schema.formType][childmodel.schema.model_name].model=childmodel.model),"ListNode"===childmodel.schema.formType&&(childmodel.edit?scope.$parent[childmodel.schema.formType][childmodel.schema.model_name].model[childmodel.edit]=childmodel.model:scope.$parent[childmodel.schema.formType][childmodel.schema.model_name].model.push(childmodel.model)),scope.$parent[childmodel.schema.formType][childmodel.schema.model_name].lengthModels+=1})})}}}),form_generator.directive("addModalForLinkedModel",function($modal,$route,Generator){return{link:function(scope,element){element.on("click",function(){var modalInstance=$modal.open({animation:!1,templateUrl:"shared/templates/linkedModelModalContent.html",controller:"ModalCtrl",size:"lg",resolve:{items:function(){return Generator.get_form({url:"crud/",form_params:{model:scope.form.model_name,cmd:"add"}})}}});modalInstance.result.then(function(childmodel,key){Generator.submit(childmodel),$route.reload()})})}}}),form_generator.directive("editModalForLinkedModel",function($modal,Generator){return{link:function(scope,element){element.on("click",function(){var modalInstance=$modal.open({animation:!1,templateUrl:"shared/templates/linkedModelModalContent.html",controller:"ModalCtrl",size:"lg",resolve:{items:function(){return Generator.get_form({url:"crud/",form_params:{model:scope.form.title,cmd:"add"}})}}});modalInstance.result.then(function(childmodel,key){Generator.submit(childmodel)})})}}}),app.directive("logout",function($http,$location,RESTURL){return{link:function($scope,$element,$rootScope){$element.on("click",function(){$http.post(RESTURL.url+"logout",{}).then(function(){$rootScope.loggedInUser=!1,$location.path("/login")})})}}}),app.directive("headerNotification",function($http,$rootScope,$interval,RESTURL){return{templateUrl:"shared/templates/directives/header-notification.html",restrict:"E",replace:!0,link:function($scope){$scope.getNotifications=function(){$http.get(RESTURL.url+"notify",{ignoreLoadingBar:!0}).success(function(data){$scope.notifications={1:[],2:[],3:[],4:[]},angular.forEach(data.notifications,function(value,key){$scope.notifications[value.type].push(value)}),$rootScope.$broadcast("notifications",$scope.notifications)})},$scope.getNotifications(),$interval(function(){$scope.getNotifications()},5e3),$scope.markAsRead=function(items){$http.post(RESTURL.url+"notify",{ignoreLoadingBar:!0,read:[items]}).success(function(data){console.log(data)})},$scope.$on("markasread",function(event,data){$scope.markAsRead(data)})}}}),app.directive("collapseMenu",function($timeout){return{templateUrl:"shared/templates/directives/menuCollapse.html",restrict:"E",replace:!0,scope:{},controller:function($scope,$rootScope){$rootScope.collapsed=!1,$rootScope.sidebarPinned=!1,$scope.collapseToggle=function(){$rootScope.collapsed===!1?(jQuery(".sidebar").css("width","62px"),jQuery(".manager-view").css("width","calc(100% - 62px)"),$rootScope.collapsed=!0,$rootScope.sidebarPinned=!1):(jQuery("span.menu-text, span.arrow, .sidebar footer").fadeIn(400),jQuery(".sidebar").css("width","250px"),jQuery(".manager-view").css("width","calc(100% - 250px)"),$rootScope.collapsed=!1,$rootScope.sidebarPinned=!0)},$timeout(function(){$scope.collapseToggle()})}}}),app.directive("headerSubMenu",function(){return{templateUrl:"shared/templates/directives/header-sub-menu.html",restrict:"E",controller:"CRUDAddEditCtrl",replace:!0,link:function($scope){$scope.triggerSubmit=function(){angular.element($("#submitbutton")).triggerHandler("click"),angular.element($("#submitbutton")).triggerHandler("click")}}}}),app.directive("headerBreadcrumb",function(){return{templateUrl:"shared/templates/directives/header-breadcrumb.html",restrict:"E",replace:!0}}),app.directive("selectedUser",function(){return{templateUrl:"shared/templates/directives/selected-user.html",restrict:"E",replace:!1,link:function($scope,$rootScope){$scope.selectedUser=$rootScope.selectedUser}}}),app.directive("sidebar",["$location",function(){return{templateUrl:"shared/templates/directives/sidebar.html",restrict:"E",replace:!0,scope:{},controller:function($scope,$rootScope,$cookies,$route,$http,RESTURL,$location,$timeout){var sidebarmenu=$("#side-menu");sidebarmenu.metisMenu(),$http.get(RESTURL.url+"menu/").success(function(data){$scope.allMenuItems=angular.copy(data),$rootScope.$broadcast("authz",data),$scope.menuItems={other:$scope.allMenuItems.other},$timeout(function(){sidebarmenu.metisMenu()})}),$scope.$on("menuitems",function(event,data){$scope.menuItems[data]=$scope.allMenuItems[data],$scope.menuItems.other=$scope.allMenuItems.other,$timeout(function(){sidebarmenu.metisMenu()})}),$scope.openSidebar=function(){$rootScope.sidebarPinned===!1&&(jQuery("span.menu-text, span.arrow, .sidebar footer, #side-menu").fadeIn(400),jQuery(".sidebar").css("width","250px"),jQuery(".manager-view").css("width","calc(100% - 250px)"),$rootScope.collapsed=!1)},$scope.closeSidebar=function(){$rootScope.sidebarPinned===!1&&(jQuery(".sidebar").css("width","62px"),jQuery(".manager-view").css("width","calc(100% - 62px)"),$rootScope.collapsed=!0)},$rootScope.$watch(function($rootScope){return $rootScope.section},function(newindex,oldindex){newindex>-1&&($scope.menuItems=[$scope.allMenuItems[newindex]],$scope.collapseVar=1)}),$scope.selectedMenu=$location.path(),$scope.collapseVar=0,$scope.multiCollapseVar=0,$scope.check=function(x){x===$scope.collapseVar?$scope.collapseVar=0:$scope.collapseVar=x},$scope.breadcrumb=function(itemlist,$event){$rootScope.breadcrumblinks=itemlist,$rootScope.showSaveButton=!1},$scope.multiCheck=function(y){y===$scope.multiCollapseVar?$scope.multiCollapseVar=0:$scope.multiCollapseVar=y}}}}]),app.directive("stats",function(){return{templateUrl:"shared/templates/directives/stats.html",restrict:"E",replace:!0,scope:{model:"=",comments:"@",number:"@",name:"@",colour:"@",details:"@",type:"@","goto":"@"}}}),app.directive("notifications",function(){return{templateUrl:"shared/templates/directives/notifications.html",restrict:"E",replace:!0}}),app.directive("sidebarSearch",function(){return{templateUrl:"shared/templates/directives/sidebar-search.html",restrict:"E",replace:!0,scope:{},controller:function($scope){$scope.selectedMenu="home"}}});var auth=angular.module("ulakbus.auth",["ngRoute","schemaForm","ngCookies","general"]);auth.controller("LoginCtrl",function($scope,$q,$timeout,$routeParams,Generator,LoginService){$scope.url="login",$scope.form_params={},$scope.form_params.clear_wf=1,Generator.get_form($scope).then(function(data){$scope.form=[{key:"username",type:"string",title:"Kullanıcı Adı"},{key:"password",type:"password",title:"Şifre"},{type:"submit",title:"Giriş Yap"}]}),$scope.onSubmit=function(form){$scope.$broadcast("schemaFormValidate"),form.$valid?LoginService.login($scope.url,$scope.model).error(function(data){$scope.message=data.title}):console.log("not valid")}}),auth.factory("LoginService",function($http,$rootScope,$location,$log,Session,RESTURL){var loginService={};return loginService.login=function(url,credentials){return credentials.cmd="do",$http.post(RESTURL.url+url,credentials).success(function(data,status,headers,config){$rootScope.loggedInUser=!0}).error(function(data,status,headers,config){return data})},loginService.logout=function(){return $log.info("logout"),$http.post(RESTURL.url+"logout",{}).success(function(data){$rootScope.loggedInUser=!1,$location.path("/login")})},loginService.isAuthenticated=function(){return!!Session.userId},loginService.isAuthorized=function(authorizedRoles){return angular.isArray(authorizedRoles)||(authorizedRoles=[authorizedRoles]),loginService.isAuthenticated()&&-1!==loginService.indexOf(Session.userRole)},loginService.isValidEmail=function(email){var re=/^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$/i;return re.test(email)},loginService}),auth.service("Session",function(){this.create=function(sessionId,userId,userRole){this.id=sessionId,this.userId=userId,this.userRole=userRole},this.destroy=function(){this.id=null,this.userId=null,this.userRole=null}}),angular.module("ulakbus.dashboard",["ngRoute"]).controller("DashCtrl",function($scope,$rootScope,$timeout,$http,$cookies,RESTURL){$scope.section=function(section_index){$rootScope.section=section_index},$scope.$on("authz",function(event,data){$scope.menuitems=data}),$scope.student_kw="",$scope.staff_kw="",$scope.students=[],$scope.staffs=[],$scope.search=function(where){$timeout(function(){"personel"===where&&$scope.staff_kw.length>2&&$scope.getItems(where,$scope.staff_kw).success(function(data){$scope.staffs=data.results}),"ogrenci"===where&&$scope.student_kw.length>2&&$scope.getItems(where,$scope.student_kw).success(function(data){$scope.students=data.results})})},$scope.getItems=function(where,what){return $http.get(RESTURL.url+"ara/"+where+"/"+what)},$scope.select=function(who,type){$rootScope.selectedUser={name:who[0],tcno:who[1],key:who[2]},$rootScope.$broadcast("menuitems",type)},$scope.$on("notifications",function(event,data){$scope.notifications=data}),$scope.markAsRead=function(items){$rootScope.$broadcast("markasread",items)}}).directive("sidebarNotifications",function(){return{templateUrl:"shared/templates/directives/sidebar-notification.html",restrict:"E",replace:!0,link:function($scope){}}});var crud=angular.module("ulakbus.crud",["ui.bootstrap","schemaForm","formService"]);crud.controller("CRUDAddEditCtrl",function($scope,$rootScope,$location,$http,$log,$modal,$timeout,Generator,$routeParams){$scope.url="crud/",$scope.form_params={model:$routeParams.model,param:$routeParams.param,id:$routeParams.id},$routeParams.key?($scope.form_params.object_id=$routeParams.key,$scope.form_params.cmd="edit"):$scope.form_params.cmd="add",$routeParams.model&&Generator.get_form($scope),$scope.onSubmit=function(form){$scope.$broadcast("schemaFormValidate"),form.$valid&&Generator.submit($scope).success(function(data){$location.path("/crud/"+$scope.form_params.model+"/"+$scope.form_params.param+"/"+$scope.form_params.id).search(data)}).error(function(data){$scope.message=data.title})}}),crud.controller("CRUDListCtrl",function($scope,$rootScope,Generator,$routeParams){$scope.url="crud/",$scope.form_params=$routeParams,$routeParams.nobjects?($scope.nobjects=$routeParams.nobjects,$scope.model=$routeParams.model):Generator.get_list($scope).then(function(res){$scope.nobjects=res.data.nobjects,$scope.model=$routeParams.model})}),crud.controller("CRUDShowCtrl",function($scope,$rootScope,$location,Generator,$routeParams){$scope.url="crud/",$scope.form_params={id:$routeParams.id,object_id:$routeParams.key,cmd:"show",param:$routeParams.param,model:$routeParams.model},Generator.get_single_item($scope).then(function(res){$scope.listobjects={},$scope.object=res.data.object,angular.forEach($scope.object,function(value,key){"object"==typeof value&&($scope.listobjects[key]=value,delete $scope.object[key])}),$scope.model=$routeParams.model})}),app.config(["$routeProvider",function($routeProvider){$routeProvider.when("/error/500",{templateUrl:"components/error_pages/500.html",controller:"500Ctrl"}).when("/error/404",{templateUrl:"components/error_pages/404.html",controller:"404Ctrl"})}]),angular.module("ulakbus.error_pages",["ngRoute"]).controller("500Ctrl",function($scope,$rootScope,$location){}).controller("404Ctrl",function($scope,$rootScope,$location){});var wf=angular.module("ulakbus.wf",["ui.bootstrap","schemaForm","formService"]);wf.controller("WFAddEditCtrl",function($scope,$rootScope,$location,$http,$log,$modal,$timeout,Generator,$routeParams){$scope.url="",$scope.form_params={model:$routeParams.model},$routeParams.model&&Generator.get_form($scope),$scope.onSubmit=function(form){$scope.$broadcast("schemaFormValidate"),form.$valid&&Generator.submit($scope).success(function(data){}).error(function(data){})}}),wf.controller("WFListCtrl",function($scope,$rootScope,Generator,$routeParams){$scope.url="",$scope.form_params=$routeParams,$routeParams.nobjects?($scope.nobjects=$routeParams.nobjects,$scope.model=$routeParams.model):Generator.get_list($scope).then(function(res){$scope.nobjects=res.data.nobjects,$scope.model=$routeParams.model})}),wf.controller("WFShowCtrl",function($scope,$rootScope,Generator,$routeParams){$scope.url="",$scope.form_params={object_id:$routeParams.id,cmd:"show",model:$routeParams.model},Generator.get_single_item($scope).then(function(res){$scope.listobjects={},$scope.object=res.data.object,angular.forEach($scope.object,function(value,key){"object"==typeof value&&($scope.listobjects[key]=value,delete $scope.object[key])}),$scope.model=$routeParams.model})}),angular.module("ulakbus.version",["ulakbus.version.interpolate-filter","ulakbus.version.version-directive"]).value("version","0.1.0"),angular.module("ulakbus.version.interpolate-filter",[]).filter("interpolate",["version",function(version){return function(text){return String(text).replace(/\%VERSION\%/gm,version)}}]),angular.module("ulakbus.version.version-directive",[]).directive("appVersion",["version",function(version){return function(scope,elm,attrs){elm.text(version)}}]);