/**
 * Copyright (C) 2015 ZetaOps Inc.
 *
 * This file is licensed under the GNU General Public License v3
 * (GPLv3).  See LICENSE.txt for details.
 */

var form_generator = angular.module('formService', []);

form_generator.factory('Generator', function ($http, $q, $log, $timeout, RESTURL) {
    var generator = {};
    generator.generate = function (modelObject) {
        return generator.group(modelObject);
    };
    generator.group = function (form_items) {
        return form_items;
    };
    generator.get_form = function (url, getParams) {
        if (getParams){
            // if form for edit then url will be
            var params;
            for (var k in getParams) {
                params += k + "=" + getParams[k] + "&";
            }
            var formUrl = RESTURL.url + url + '?' + params;
        } else {
            // if form for create then url will be
            var formUrl = RESTURL.url + url;
        }
        return $http
            .get(formUrl)
            .then(function (res) {
                if (res.status == 200) {
                    // todo: remove 0 index with real api
                    return generator.generate(res.data[0]);
                }
                // todo: cover all other exceptions (4xx, 5xx)
            });
    };
    generator.isValidEmail = function(email){
        var re = /^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$/i;
        return re.test(email);
    };
    generator.asyncValidators = {
        emailNotValid: function (value) {
            var deferred = $q.defer();
            $timeout(function () {
                if (generator.isValidEmail(value)) {
                    deferred.resolve();
                } else {
                    deferred.reject();
                }
            }, 500);
            return deferred.promise;
        }
    };
    generator.submit = function ($scope) {
        $scope.$broadcast('schemaFormValidate');
        //if ($scope.form.$valid) {
            $http.post('http://127.0.0.1:3000/api/add_student', $scope.model).then(function(res){$log.info(res);});
        //}
    };
    return generator;
});