/*! ulakbus-ui  2016-01-26 */
"use strict";angular.module("ulakbus",["ui.bootstrap","angular-loading-bar","ngRoute","ngSanitize","ngCookies","ulakbus.formService","ulakbus.dashboard","ulakbus.auth","ulakbus.error_pages","ulakbus.crud","ulakbus.debug","ulakbus.devSettings","ulakbus.version","gettext","templates-prod"]).constant("RESTURL",function(){var backendurl=location.href.indexOf("nightly")>-1?"//nightly.api.ulakbus.net/":"//api.ulakbus.net/";if(document.cookie.indexOf("backendurl")>-1){var cookiearray=document.cookie.split(";");angular.forEach(cookiearray,function(item){item.indexOf("backendurl")>-1&&(backendurl=item.split("=")[1])})}if(location.href.indexOf("backendurl")>-1){var urlfromqstr=location.href.split("?")[1].split("=")[1];backendurl=decodeURIComponent(urlfromqstr.replace(/\+/g," ")),document.cookie="backendurl="+backendurl,window.location.href=window.location.href.split("?")[0]}return{url:backendurl}}()).constant("USER_ROLES",{all:"*",admin:"admin",student:"student",staff:"staff",dean:"dean"}).constant("AUTH_EVENTS",{loginSuccess:"auth-login-success",loginFailed:"auth-login-failed",logoutSuccess:"auth-logout-success",sessionTimeout:"auth-session-timeout",notAuthenticated:"auth-not-authenticated",notAuthorized:"auth-not-authorized"}).config(function($logProvider){$logProvider.debugEnabled(!1)}),angular.module("ulakbus").config(["$routeProvider",function($routeProvider,$route){$routeProvider.when("/login",{templateUrl:"components/auth/login.html",controller:"LoginCtrl"}).when("/dashboard",{templateUrl:"components/dashboard/dashboard.html",controller:"DashCtrl"}).when("/dev/settings",{templateUrl:"components/devSettings/devSettings.html",controller:"DevSettingsCtrl"}).when("/debug/list",{templateUrl:"components/debug/debug.html",controller:"DebugCtrl"}).when("/:wf/",{templateUrl:"components/crud/templates/crud.html",controller:"CRUDCtrl"}).when("/:wf/do/:cmd",{templateUrl:"components/crud/templates/crud.html",controller:"CRUDListFormCtrl"}).when("/:wf/do/:cmd/:key",{templateUrl:"components/crud/templates/crud.html",controller:"CRUDListFormCtrl"}).when("/:wf/:model",{templateUrl:"components/crud/templates/crud.html",controller:"CRUDCtrl"}).when("/:wf/:model/do/:cmd",{templateUrl:"components/crud/templates/crud.html",controller:"CRUDListFormCtrl"}).when("/:wf/:model/do/:cmd/:key",{templateUrl:"components/crud/templates/crud.html",controller:"CRUDListFormCtrl"}).otherwise({redirectTo:"/dashboard"})}]).run(function($rootScope){$rootScope.loggedInUser=!0,$rootScope.loginAttempt=0,$rootScope.$on("$routeChangeStart",function(event,next,current){})}).config(["$httpProvider",function($httpProvider){$httpProvider.defaults.withCredentials=!0}]).run(function(gettextCatalog){gettextCatalog.setCurrentLanguage("tr"),gettextCatalog.debug=!0}).config(["cfpLoadingBarProvider",function(cfpLoadingBarProvider){cfpLoadingBarProvider.includeBar=!1,cfpLoadingBarProvider.parentSelector="loaderdiv",cfpLoadingBarProvider.spinnerTemplate='<div class="loader">Loading...</div>'}]),angular.module("ulakbus").config(["$httpProvider",function($httpProvider){$httpProvider.interceptors.push(function($q,$rootScope,$location,$timeout,$log){return{request:function(config){return"POST"===config.method&&(config.headers["Content-Type"]="text/plain"),config},response:function(response){return response.data._debug_queries&&response.data._debug_queries.length>0&&($rootScope.debug_queries=$rootScope.debug_queries||[],$rootScope.debug_queries.push({url:response.config.url,queries:response.data._debug_queries})),response.data.is_login===!1&&($rootScope.loggedInUser=response.data.is_login,$location.path("/login")),response.data.is_login===!0&&($rootScope.loggedInUser=!0,$rootScope.loginAttempt=1,"/login"===$location.path()&&$location.path("/dashboard")),response},responseError:function(rejection){var errorModal=function(){if(0===$rootScope.loginAttempt)return void $log.debug("not logged in, no alert message triggered");var codefield="";rejection.data.error&&(codefield="<p><pre>"+rejection.data.error+"</pre></p>"),$('<div class="modal"><div class="modal-dialog" style="width:100%;" role="document"><div class="modal-content"><div class="modal-header"><button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button><h4 class="modal-title" id="exampleModalLabel">'+rejection.status+rejection.data.title+'</h4></div><div class="modal-body"><div class="alert alert-danger"><strong>'+rejection.data.description+"</strong>"+codefield+'</div></div><div class="modal-footer"><button type="button" class="btn btn-default" data-dismiss="modal">Kapat</button></div></div></div></div>').modal();try{$("pre:not(.hljs)").each(function(i,block){hljs.highlightBlock(block)})}catch(e){$log.debug("Exception: ",e.message)}};return-1===rejection.status&&(rejection.status="Sunucu hatası",rejection.data={title:"",description:"Sunucu bağlantısında bir hata oluştu.Lütfen yetkili personelle iletişime geçiniz."},$rootScope.$broadcast("alertBox",{title:rejection.status,msg:rejection.data.description,type:"error"})),400===rejection.status&&$location.reload(),401===rejection.status&&($location.path("/login"),"/login"===$location.path()&&$log.debug("show errors on login form")),403===rejection.status&&rejection.data.is_login===!0&&($rootScope.loggedInUser=!0,"/login"===$location.path()&&$location.path("/dashboard")),$rootScope.$broadcast("show_notifications",rejection.data),404===rejection.status&&errorModal(),500===rejection.status&&errorModal(),$q.reject(rejection)}}})}]),angular.module("ulakbus.formService",["ui.bootstrap"]).service("Moment",function(){return window.moment}).factory("Generator",function($http,$q,$timeout,$sce,$location,$route,$compile,$log,RESTURL,$rootScope,Moment){var generator={};return generator.makeUrl=function(scope){var getparams=scope.form_params.param?"?"+scope.form_params.param+"="+scope.form_params.id:"";return RESTURL.url+scope.url+getparams},generator.generate=function(scope,data){return data.forms?(angular.forEach(data.forms,function(value,key){scope[key]=data.forms[key]}),scope.client_cmd=data.client_cmd,scope.token=data.token,scope.initialModel=angular.copy(scope.model),generator.prepareFormItems(scope),scope.object_id=scope.form_params.object_id,$log.debug("scope at after generate",scope),scope):scope},generator.group=function(scope){if(!scope.grouping)return scope;var newForm=[],extractFormItem=function(itemList){var extractedList=[];return angular.forEach(itemList,function(value,key){var item=getFormItem(value);item&&extractedList.push(item)}),$log.debug("extractedList: ",extractedList),extractedList},getFormItem=function(item){var formItem;return scope.form.indexOf(item)>-1?(formItem=scope.form[scope.form.indexOf(item)],scope.form.splice(scope.form.indexOf(item),1),formItem):(angular.forEach(scope.form,function(value,key){return value.key===item?(formItem=value,void scope.form.splice(key,1)):void 0}),formItem)},makeGroup=function(itemsToGroup){var subItems=[];return angular.forEach(itemsToGroup,function(value,key){subItems.push({type:"fieldset",items:extractFormItem(value.items),title:value.group_title})}),subItems};return angular.forEach(scope.grouping,function(value,key){newForm.push({type:"fieldset",items:makeGroup(value.groups),htmlClass:"col-md-"+value.layout,title:value.group_title})}),$log.debug("grouped form: ",newForm),$log.debug("rest of form: ",scope.form),$log.debug("form united: ",newForm.concat(scope.form)),scope.form=newForm.concat(scope.form),scope},generator.prepareFormItems=function(scope){return angular.forEach(scope.form,function(value,key){"select"===value.type&&(scope.schema.properties[value.key].type="select",scope.schema.properties[value.key].titleMap=value.titleMap,scope.form[key]=value.key)}),angular.forEach(scope.schema.properties,function(v,k){if("form_params"in scope&&k==scope.form_params.param)return scope.model[k]=scope.form_params.id,void scope.form.splice(scope.form.indexOf(k),1);if("file"===v.type&&(scope.form[scope.form.indexOf(k)]={type:"template",title:v.title,templateUrl:"shared/templates/filefield.html",name:k,key:k,fileInsert:function(){$scope.$broadcast("schemaForm.error."+k,"tv4-302",!0)},imageSrc:scope.model[k]?$rootScope.settings.static_url+scope.model[k]:"",avatar:"avatar"===k?!0:!1},v.type="string"),"select"===v.type&&(scope.form[scope.form.indexOf(k)]={type:"template",title:v.title,templateUrl:"shared/templates/select.html",name:k,key:k,titleMap:v.titleMap}),"submit"===v.type||"button"===v.type){var buttonPositions=scope.modalElements?scope.modalElements.buttonPositions:{bottom:"move-to-bottom",top:"move-to-top",none:""},workOnForm=scope.modalElements?scope.modalElements.workOnForm:"formgenerated",workOnDiv=scope.modalElements?scope.modalElements.workOnDiv:"",buttonClass=buttonPositions[v.position]||buttonPositions.bottom,redirectTo=scope.modalElements?!1:!0;scope.form[scope.form.indexOf(k)]={type:v.type,title:v.title,style:"btn-danger hide "+buttonClass,onClick:function(){delete scope.form_params.cmd,delete scope.form_params.flow,v.cmd&&(scope.form_params.cmd=v.cmd),v.flow&&(scope.form_params.flow=v.flow),v.wf&&(delete scope.form_params.cmd,scope.form_params.wf=v.wf),scope.model[k]=1,scope.modalElements?scope.submitModalForm():v.validation===!1?generator.submit(scope,redirectTo):(scope.$broadcast("schemaFormValidate"),scope[workOnForm].$valid&&(generator.submit(scope,redirectTo),scope.$broadcast("disposeModal")))}},$timeout(function(){var selectorBottom=".buttons-on-bottom"+workOnDiv,buttonsToBottom=angular.element(document.querySelector("."+buttonClass));angular.element(document.querySelector(selectorBottom)).append(buttonsToBottom),buttonsToBottom.removeClass("hide")},500)}if("date"===v.type&&($log.debug("date:",scope.model[k]),scope.model[k]=generator.dateformatter(scope.model[k]),scope.form[scope.form.indexOf(k)]={key:k,name:k,title:v.title,type:"template",templateUrl:"shared/templates/datefield.html",validationMessage:{dateNotValid:"Girdiğiniz tarih geçerli değildir. <i>orn: '01.01.2015'<i/>",302:"Bu alan zorunludur."},$asyncValidators:{dateNotValid:function(value){var deferred=$q.defer();return $timeout(function(){if(scope.model[k]=angular.copy(generator.dateformatter(value)),scope.schema.required.indexOf(k)>-1&&deferred.resolve(),value.constructor===Date)deferred.resolve();else{var dateValue=d=value.split(".");isNaN(Date.parse(value))||3!==dateValue.length?deferred.reject():deferred.resolve()}}),deferred.promise}},status:{opened:!1},open:function($event){this.status.opened=!0},format:"dd.MM.yyyy",onSelect:function(){scope.model[k]=angular.copy(generator.dateformatter(scope.model[k]))}}),("int"===v.type||"float"===v.type)&&(v.type="number",scope.model[k]=parseInt(scope.model[k])),"text_general"===v.type&&(v.type="string",v["x-schema-form"]={type:"textarea"}),"model"===v.type){var formitem=scope.form[scope.form.indexOf(k)],modelScope={url:v.wf,wf:v.wf,form_params:{model:v.model_name,cmd:v.list_cmd}};scope.generateTitleMap=function(modelScope){return generator.get_list(modelScope).then(function(res){return formitem.titleMap=[],angular.forEach(res.data.objects,function(item){-1!==item?formitem.titleMap.push({value:item.key,name:item.value}):formitem.focusToInput=!0}),formitem.titleMap})},scope.model[k]&&generator.get_list({url:"crud",form_params:{model:v.model_name,object_id:scope.model[k],cmd:"object_name"}}).then(function(data){try{scope.$watch(document.querySelector("input[name="+v.model_name+"]"),function(){document.querySelector("input[name="+k+"]").value=data.data.object_name})}catch(e){document.querySelector("input[name="+k+"]").value=data.data.object_name,$log.debug("exception",e)}}),formitem={type:"template",templateUrl:"shared/templates/foreignKey.html",formName:k,title:v.title,wf:v.wf,add_cmd:v.add_cmd,name:k,key:k,model_name:v.model_name,selected_item:{},titleMap:[],onSelect:function(item,inputname){scope.model[k]=item.value,$timeout(function(){document.querySelector("input[name="+inputname+"]").value=item.name})},onDropdownSelect:function(item,inputname){scope.model[k]=item.value,$timeout(function(){document.querySelector("input[name="+inputname+"]").value=item.name})},getTitleMap:function(viewValue){return modelScope.form_params.query=viewValue,scope.generateTitleMap(modelScope)},getDropdownTitleMap:function(){delete modelScope.form_params.query,formitem.gettingTitleMap=!0,scope.generateTitleMap(modelScope).then(function(data){formitem.titleMap=data,formitem.gettingTitleMap=!1})}},scope.form[scope.form.indexOf(k)]=formitem}if(("ListNode"===v.type||"Node"===v.type)&&"filter_interface"===v.widget){var formitem=scope.form[scope.form.indexOf(k)],modelScope={url:v.wf||scope.wf,wf:v.wf||scope.wf,form_params:{model:v.model_name||v.schema[0].model_name,cmd:v.list_cmd||"select_list",query:""}};scope.generateTitleMap=function(modelScope){generator.get_list(modelScope).then(function(res){formitem.titleMap=[],angular.forEach(res.data.objects,function(item){"-1"!==item&&formitem.titleMap.push({value:item.key,name:item.value})}),formitem.filteredItems=generator.get_diff_array(angular.copy(formitem.titleMap),angular.copy(formitem.selectedFilteredItems),1)})};var modelItems=[],modelKeys=[];angular.forEach(scope.model[k],function(value,mkey){modelItems.push({value:value[v.schema[0].name].key,name:value[v.schema[0].name].unicode});var modelKey={};modelKey[v.schema[0].name]=value[v.schema[0].name].key,modelKeys.push(modelKey)}),scope.model[k]=angular.copy(modelKeys),formitem={type:"template",templateUrl:"shared/templates/multiselect.html",title:v.title,formName:k,wf:v.wf,add_cmd:v.add_cmd,name:v.model_name,model_name:v.model_name,filterValue:"",selected_item:{},filteredItems:[],selectedFilteredItems:modelItems,titleMap:scope.generateTitleMap(modelScope),appendFiltered:function(filterValue){filterValue.length>2&&(formitem.filteredItems=[],angular.forEach(formitem.titleMap,function(value,key){value.name.indexOf(filterValue)>-1&&formitem.filteredItems.push(formitem.titleMap[key])})),2>=filterValue&&(formitem.filteredItems=formitem.titleMap),formitem.filteredItems=generator.get_diff_array(formitem.filteredItems,formitem.selectedFilteredItems)},select:function(selectedItemsModel){selectedItemsModel&&(formitem.selectedFilteredItems=formitem.selectedFilteredItems.concat(selectedItemsModel),formitem.appendFiltered(formitem.filterValue),scope.model[k]=(scope.model[k]||[]).concat(formitem.dataToModel(selectedItemsModel)))},deselect:function(selectedFilteredItemsModel){selectedFilteredItemsModel&&(formitem.selectedFilteredItems=generator.get_diff_array(angular.copy(formitem.selectedFilteredItems),angular.copy(selectedFilteredItemsModel)),formitem.appendFiltered(formitem.filterValue),formitem.filteredItems=formitem.filteredItems.concat(selectedFilteredItemsModel),scope.model[k]=generator.get_diff_array(scope.model[k]||[],formitem.dataToModel(selectedFilteredItemsModel)))},dataToModel:function(data){var dataValues=[];return angular.forEach(data,function(value,key){var dataKey={};dataKey[v.schema[0].name]=value.value,dataValues.push(dataKey)}),dataValues}},scope.form[scope.form.indexOf(k)]=formitem}"ListNode"!==v.type&&"Node"!==v.type||"filter_interface"===v.widget||(scope[v.type]=scope[v.type]||{},scope[v.type][k]=angular.copy({title:v.title,form:[],schema:{properties:{},required:[],title:v.title,type:"object",formType:v.type,model_name:k,inline_edit:scope.inline_edit},url:scope.url,wf:scope.wf,nodeModelChange:function(item){}}),angular.forEach(v.schema,function(item){scope[v.type][k].schema.properties[item.name]=angular.copy(item),item.required===!0&&"idx"!==item.name&&scope[v.type][k].schema.required.push(angular.copy(item.name)),"idx"!==item.name&&scope[v.type][k].form.push(item.name);try{"date"===item.type&&(scope.model[k][item.name]=generator.dateformatter(scope.model[k][item.name]))}catch(e){$log.debug("Error: ",e.message)}}),$timeout(function(){"ListNode"===v.type&&(scope[v.type][k].items=angular.copy(scope.model[k]||[]),angular.forEach(scope[v.type][k].items,function(value,key){value.constructor===Object&&angular.forEach(value,function(x,y){try{"date"===scope[v.type][k].schema.properties[y].type&&(scope[v.type][k].items[key][y]=generator.dateformatter(x),scope[v.type][k].model[key][y]=generator.dateformatter(x)),"select"===scope[v.type][k].schema.properties[y].type&&(scope[v.type][k].items[key][y]=generator.item_from_array(x.toString(),scope[v.type][k].schema.properties[y].titleMap))}catch(e){$log.debug("Field is not date")}})}))}),scope.model[k]&&angular.forEach(scope.model[k],function(value,key){angular.forEach(value,function(y,x){y.constructor===Object&&(scope.model[k][key][x]=y.key)})}),scope.model[k]=scope.model[k]||[],scope[v.type][k].model=scope.model[k],scope[v.type][k].lengthModels=scope.model[k]?1:0)}),$log.debug("scope at after prepareformitems",scope),generator.group(scope)},generator.dateformatter=function(formObject){var ndate=new Date(formObject);if(isNaN(ndate))return"";var newdatearray=Moment(ndate).format("DD.MM.YYYY");return $log.debug("date formatted: ",newdatearray),newdatearray},generator.doItemAction=function($scope,key,todo,mode){var _do={normal:function(){return $log.debug("normal mode starts"),$scope.form_params.cmd=todo.cmd,todo.wf&&($scope.url=todo.wf,$scope.form_params.wf=todo.wf,delete $scope.token,delete $scope.form_params.model,delete $scope.form_params.cmd),todo.object_key?$scope.form_params[todo.object_key]=key:$scope.form_params.object_id=key,$scope.form_params.param=$scope.param,$scope.form_params.id=$scope.param_id,$scope.form_params.token=$scope.token,generator.get_wf($scope)},modal:function(){$log.debug("modal mode is not not ready")},"new":function(){$log.debug("new mode is not not ready")}};return _do[mode]()},generator.get_form=function(scope){return $http.post(generator.makeUrl(scope),scope.form_params).then(function(res){return generator.generate(scope,res.data)})},generator.get_list=function(scope){return $http.post(generator.makeUrl(scope),scope.form_params).then(function(res){return res})},generator.get_wf=function(scope){return $http.post(generator.makeUrl(scope),scope.form_params).then(function(res){if(res.data.client_cmd)return generator.pathDecider(res.data.client_cmd,scope,res.data);if(res.data.msgbox){scope.msgbox=res.data.msgbox;var newElement=$compile("<msgbox></msgbox>")(scope);angular.element(document.querySelector(".main.ng-scope")).children().remove(),angular.element(document.querySelector(".main.ng-scope")).append(newElement)}})},generator.isValidEmail=function(email){var re=/^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$/i;return re.test(email)},generator.isValidTCNo=function(tcno){var re=/^([1-9]{1}[0-9]{9}[0,2,4,6,8]{1})$/i;return re.test(tcno)},generator.isValidDate=function(dateValue){return!isNaN(Date.parse(dateValue))},generator.pageData={},generator.getPageData=function(){return generator.pageData},generator.setPageData=function(value){generator.pageData=value},generator.pathDecider=function(client_cmd,$scope,data){function redirectTo(scope,page){var pathUrl="/"+scope.form_params.wf;return pathUrl+=scope.form_params.model?"/"+scope.form_params.model+"/do/"+page:"/do/"+page,$location.path()===pathUrl?$route.reload():void $location.path(pathUrl)}function dispatchClientCmd(){data[$scope.form_params.param]=$scope.form_params.id,data.model=$scope.form_params.model,data.wf=$scope.form_params.wf,data.param=$scope.form_params.param,data.param_id=$scope.form_params.id,data.pageData=!0,data.second_client_cmd=client_cmd[1],generator.setPageData(data),redirectTo($scope,client_cmd[0])}return"reload"===client_cmd[0]||"reset"===client_cmd[0]?void $rootScope.$broadcast("reload_cmd",$scope.reload_cmd):void dispatchClientCmd()},generator.get_diff=function(obj1,obj2){var result={};return angular.forEach(obj1,function(value,key){obj2[key]!=obj1[key]&&(result[key]=angular.copy(obj1[key])),obj2[key].constructor===Array&&obj1[key].constructor===Array&&(result[key]=arguments.callee(obj1[key],obj2[key])),obj2[key].constructor===Object&&obj1[key].constructor===Object&&(result[key]=arguments.callee(obj1[key],obj2[key]))}),result},generator.get_diff_array=function(array1,array2,way){var result=[];return angular.forEach(array1,function(value,key){1===way?angular.toJson(array2).indexOf(value.value)<0&&result.push(value):angular.toJson(array2).indexOf(angular.toJson(value))<0&&result.push(value)}),result},generator.item_from_array=function(item,array){var result=item;return angular.forEach(array,function(value,key){value.value===item&&(result=value.name)}),result},generator.submit=function($scope,redirectTo){angular.forEach($scope.ListNode,function(value,key){$scope.model[key]=value.model}),angular.forEach($scope.Node,function(value,key){$scope.model[key]=value.model});var data={form:$scope.model,token:$scope.token,model:$scope.form_params.model,cmd:$scope.form_params.cmd,flow:$scope.form_params.flow,object_id:$scope.object_id,filter:$scope.filter,query:$scope.form_params.query};return $http.post(generator.makeUrl($scope),data).success(function(data,status,headers){if("application/pdf"===headers("content-type")){var a=document.createElement("a");document.body.appendChild(a),a.style="display: none";var file=new Blob([data],{type:"application/pdf"}),fileURL=URL.createObjectURL(file),fileName=$scope.schema.title;a.href=fileURL,a.download=fileName,a.click()}if(redirectTo===!0&&(data.client_cmd&&generator.pathDecider(data.client_cmd,$scope,data),data.msgbox)){$scope.msgbox=data.msgbox;var newElement=$compile("<msgbox></msgbox>")($scope);angular.element(document.querySelector(".main.ng-scope")).children().remove(),angular.element(document.querySelector(".main.ng-scope")).append(newElement)}})},generator}).controller("ModalCtrl",function($scope,$uibModalInstance,Generator,items){angular.forEach(items,function(value,key){$scope[key]=items[key]}),$scope.$on("disposeModal",function(){$scope.cancel()}),$scope.$on("modalFormLocator",function(event){$scope.linkedModelForm=event.targetScope.linkedModelForm}),$scope.$on("submitModalForm",function(){$scope.onSubmit($scope.linkedModelForm)}),$scope.$on("validateModalDate",function(event,field){$scope.$broadcast("schemaForm.error."+field,"tv4-302",!0)}),$scope.onSubmit=function(form){$scope.$broadcast("schemaFormValidate"),form.$valid&&$uibModalInstance.close($scope)},$scope.onNodeSubmit=function(){$scope.$broadcast("schemaFormValidate"),$scope.modalForm.$valid&&$uibModalInstance.close($scope)},$scope.cancel=function(){$uibModalInstance.dismiss("cancel")}}).directive("modalForNodes",function($uibModal,Generator){return{link:function(scope,element,attributes){element.on("click",function(){var modalInstance=$uibModal.open({animation:!0,backdrop:"static",keyboard:!1,templateUrl:"shared/templates/listnodeModalContent.html",controller:"ModalCtrl",size:"lg",resolve:{items:function(){var attribs=attributes.modalForNodes.split(","),node=angular.copy(scope.$parent[attribs[1]][attribs[0]]);"add"===attribs[2]&&(node.model={}),attribs[3]&&(node.model=node.model[attribs[3]]),node.edit=attribs[3],scope.node.schema.wf=scope.node.url,angular.forEach(scope.node.schema.properties,function(value,key){scope.node.schema.properties[key].wf=scope.node.url,scope.node.schema.properties[key].list_cmd="select_list"});var newscope={wf:scope.node.wf,url:scope.node.url,form_params:{model:scope.node.schema.model_name},edit:attribs[3]};return Generator.generate(newscope,{forms:scope.node}),newscope.model=newscope.model[node.edit]||newscope.model[0]||{},newscope}}});modalInstance.result.then(function(childmodel,key){var listNodeItem=scope.$parent[childmodel.schema.formType][childmodel.schema.model_name];if("Node"===childmodel.schema.formType&&(listNodeItem.model=angular.copy(childmodel.model),listNodeItem.lengthModels+=1),"ListNode"===childmodel.schema.formType){var reformattedModel={};angular.forEach(childmodel.model,function(value,key){key.indexOf("_id")>-1?angular.forEach(childmodel.form,function(v,k){function indexInTitleMap(element,index,array){return element.value===value?element:void 0}v.formName===key&&(reformattedModel[key]={key:value,unicode:v.titleMap.find(indexInTitleMap).name})}):reformattedModel[key]={key:key,unicode:Generator.item_from_array(value,childmodel.schema.properties[key].titleMap)}}),childmodel.edit?(listNodeItem.model[childmodel.edit]=childmodel.model,Object.keys(reformattedModel).length>0?listNodeItem.items[childmodel.edit]=reformattedModel:listNodeItem.items[childmodel.edit]=angular.copy(childmodel.model)):(listNodeItem.model.push(angular.copy(childmodel.model)),Object.keys(reformattedModel).length>0?listNodeItem.items.push(reformattedModel):listNodeItem.items.push(angular.copy(childmodel.model))),listNodeItem.lengthModels+=1}})})}}}).directive("addModalForLinkedModel",function($uibModal,$rootScope,$route,Generator){return{link:function(scope,element,attributes){element.on("click",function(){var modalInstance=$uibModal.open({animation:!0,backdrop:"static",keyboard:!1,templateUrl:"shared/templates/linkedModelModalContent.html",controller:"ModalCtrl",size:"lg",resolve:{items:function(){var formName=attributes.addModalForLinkedModel;return Generator.get_form({url:scope.form.wf,wf:scope.form.wf,form_params:{model:scope.form.model_name,cmd:scope.form.add_cmd},modalElements:{buttonPositions:{bottom:"move-to-bottom-modal",top:"move-to-top-modal",none:""},workOnForm:"linkedModelForm",workOnDiv:"-modal"+formName},submitModalForm:function(){$rootScope.$broadcast("submitModalForm")},validateModalDate:function(field){$rootScope.$broadcast("validateModalDate",field)},formName:formName})}}});modalInstance.result.then(function(childscope,key){var formName=childscope.formName;Generator.submit(childscope,!1).success(function(data){scope.model[formName]=data.forms.model.object_key,scope.form.titleMap.push({value:data.forms.model.object_key,name:data.forms.model.unicode}),scope.form.selected_item={value:data.forms.model.object_key,name:data.forms.model.unicode},scope.$watch(document.querySelector("input[name="+scope.form.model_name+"]"),function(){angular.element(document.querySelector("input[name="+scope.form.model_name+"]")).val(scope.form.selected_item.name)})})})})}}}).directive("modalFormLocator",function(){return{link:function(scope){scope.$emit("modalFormLocator")}}}),angular.module("ulakbus").directive("logout",function($http,$location,RESTURL){return{link:function($scope,$element,$rootScope){$element.on("click",function(){$http.post(RESTURL.url+"logout",{}).then(function(){$rootScope.loggedInUser=!1,$location.path("/login")})})}}}).directive("headerNotification",function($http,$rootScope,$cookies,$interval,RESTURL){return{templateUrl:"shared/templates/directives/header-notification.html",restrict:"E",replace:!0,link:function($scope){$scope.groupNotifications=function(notifications){$scope.notifications={1:[],2:[],3:[],4:[]},angular.forEach(notifications,function(value,key){$scope.notifications[value.type].push(value)})},$scope.getNotifications=function(){$http.get(RESTURL.url+"notify",{ignoreLoadingBar:!0}).success(function(data){$scope.groupNotifications(data.notifications),$rootScope.$broadcast("notifications",$scope.notifications)})},$scope.getNotifications(),$interval(function(){"on"==$cookies.get("notificate")&&$scope.getNotifications()},5e3),$scope.markAsRead=function(items){$http.post(RESTURL.url+"notify",{ignoreLoadingBar:!0,read:[items]}).success(function(data){$scope.groupNotifications(data.notifications),$rootScope.$broadcast("notifications",$scope.notifications)})},$scope.$on("markasread",function(event,data){$scope.markAsRead(data)})}}}).directive("searchDirective",function(Generator,$log,$rootScope){return{templateUrl:"shared/templates/directives/search.html",restrict:"E",replace:!0,link:function($scope){$scope.searchForm=[{key:"searchbox",htmlClass:"pull-left"},{type:"submit",title:"Ara",style:"btn-info",htmlClass:"pull-left"}],$scope.searchSchema={type:"object",properties:{searchbox:{type:"string",minLength:2,title:"Ara","x-schema-form":{placeholder:"Arama kriteri giriniz..."}}},required:[]},$scope.searchModel={searchbox:""},$scope.searchSubmit=function(form){if($scope.$broadcast("schemaFormValidate"),form.$valid){var searchparams={url:$scope.wf,token:$scope.$parent.token,object_id:$scope.$parent.object_id,form_params:{model:$scope.$parent.form_params.model,cmd:$scope.$parent.reload_cmd,flow:$scope.$parent.form_params.flow,query:$scope.searchModel.searchbox}};Generator.submit(searchparams).success(function(data){$rootScope.$broadcast("updateObjects",data.objects)})}}}}}).directive("sortDirective",function(Generator,$log){return{templateUrl:"shared/templates/directives/sort.html",restrict:"E",replace:!0,link:function($scope){$scope.titleMap=[{value:"artan",name:"Artan"},{value:"azalan",name:"Azalan"}],$scope.sortForm=[{key:"sortbox",htmlClass:"pull-left",type:"select",titleMap:$scope.titleMap},{type:"submit",title:"Sırala",htmlClass:"pull-left"}],$scope.sortSchema={type:"object",properties:{sortbox:{type:"select",title:"Sırala"}},required:["sortbox"]},$scope.sortModel={sortbox:""},$scope.sortSubmit=function(form){if($scope.$broadcast("schemaFormValidate"),form.$valid){var sortparams={url:$scope.wf,token:$scope.$parent.token,object_id:$scope.$parent.object_id,form_params:{model:$scope.$parent.form_params.model,cmd:$scope.$parent.reload_cmd,flow:$scope.$parent.form_params.flow,param:"sort",id:$scope.sortModel.sortbox}};Generator.submit(sortparams)}}}}}).directive("collapseMenu",function($timeout,$window,$cookies){return{templateUrl:"shared/templates/directives/menuCollapse.html",restrict:"E",replace:!0,scope:{},controller:function($scope,$rootScope){$rootScope.collapsed=!1,$rootScope.sidebarPinned=$cookies.get("sidebarPinned")||0,$scope.collapseToggle=function(){$window.innerWidth>"768"&&($rootScope.collapsed===!1?(jQuery(".sidebar").css("width","62px"),jQuery(".manager-view").css("width","calc(100% - 62px)"),$rootScope.collapsed=!0,$rootScope.sidebarPinned=0,$cookies.put("sidebarPinned",0)):(jQuery("span.menu-text, span.arrow, .sidebar footer").fadeIn(400),jQuery(".sidebar").css("width","250px"),jQuery(".manager-view").css("width","calc(100% - 250px)"),$rootScope.collapsed=!1,$rootScope.sidebarPinned=1,$cookies.put("sidebarPinned",1)))},$timeout(function(){"0"===$cookies.get("sidebarPinned")&&$scope.collapseToggle()})}}}).directive("headerSubMenu",function($location){return{templateUrl:"shared/templates/directives/header-sub-menu.html",restrict:"E",replace:!0,link:function($scope){$scope.style="width:calc(100% - 300px);",$scope.$on("$routeChangeStart",function(){$scope.style="/dashboard"===$location.path()?"width:calc(100% - 300px);":"width:%100 !important;"})}}}).directive("headerBreadcrumb",function($location){return{templateUrl:"shared/templates/directives/header-breadcrumb.html",restrict:"E",replace:!1,link:function($scope){$scope.goBack=function(){$location.state()}}}}).directive("selectedUser",function($http,RESTURL){return{templateUrl:"shared/templates/directives/selected-user.html",restrict:"E",replace:!0,link:function($scope,$rootScope){$scope.$on("selectedUser",function($event,data){$scope.selectedUser=data,$scope.dynamicPopover={content:"",name:data.name,tcno:data.tcno,key:data.key,templateUrl:"shared/templates/directives/selectedUserPopover.html",title:"İşlem Yapılan Kişi"}}),$scope.$on("selectedUserTrigger",function($event,data){({model:"Personel",cmd:"show",id:data[1]});$http.get(RESTURL.url+"ara/personel/"+data[1]).success(function(data){})})}}}).directive("sidebar",["$location",function(){return{templateUrl:"shared/templates/directives/sidebar.html",restrict:"E",replace:!0,scope:{},controller:function($scope,$rootScope,$cookies,$route,$http,RESTURL,$log,$location,$window,$timeout){$scope.prepareMenu=function(menuItems){var newMenuItems={};return angular.forEach(menuItems,function(value,key){angular.forEach(value,function(v,k){newMenuItems[k]=v})}),newMenuItems};var sidebarmenu=$("#side-menu");sidebarmenu.metisMenu(),$http.get(RESTURL.url+"menu/").success(function(data){
function reGroupMenuItems(items,baseCategory){var newItems={};return angular.forEach(items,function(value,key){newItems[value.kategori]=newItems[value.kategori]||[],value.baseCategory=baseCategory,newItems[value.kategori].push(value)}),newItems}$scope.allMenuItems=angular.copy(data),angular.forEach($scope.allMenuItems,function(value,key){"current_user"!==key&&"settings"!==key&&($scope.allMenuItems[key]=reGroupMenuItems(value,key))}),$rootScope.quick_menu=reGroupMenuItems(data.quick_menu,"quick_menus"),$rootScope.quick_menu=data.quick_menu,delete data.quick_menu,$log.debug("quick menu",$rootScope.quick_menu),$rootScope.$broadcast("authz",data),$rootScope.searchInputs=data,$rootScope.current_user=data.current_user,(data.ogrenci||data.personel)&&($rootScope.current_user.can_search=!0),$rootScope.settings=data.settings,$scope.menuItems=$scope.prepareMenu({other:$scope.allMenuItems.other}),$timeout(function(){sidebarmenu.metisMenu()})}),$scope.$on("menuitems",function(event,data){var menu={};menu[data]=$scope.allMenuItems[data],$rootScope.$broadcast("usermenuitems",$scope.prepareMenu(menu))}),$scope.$on("selectedUser",function($event,data){$scope.selectedUser=data}),$scope.deselectUser=function(){delete $scope.selectedUser,delete $scope.selectedMenuItems},$scope.openSidebar=function(){$window.innerWidth>"768"&&0===$rootScope.sidebarPinned&&(jQuery("span.menu-text, span.arrow, .sidebar footer, #side-menu").fadeIn(400),jQuery(".sidebar").css("width","250px"),jQuery(".manager-view").css("width","calc(100% - 250px)"),$rootScope.collapsed=!1)},$scope.closeSidebar=function(){$window.innerWidth>"768"&&0===$rootScope.sidebarPinned&&(jQuery(".sidebar").css("width","62px"),jQuery(".manager-view").css("width","calc(100% - 62px)"),$rootScope.collapsed=!0)},$rootScope.$watch(function($rootScope){return $rootScope.section},function(newindex,oldindex){newindex>-1&&($scope.menuItems=[$scope.allMenuItems[newindex]],$scope.collapseVar=0)}),$scope.selectedMenu=$location.path(),$scope.collapseVar=0,$scope.multiCollapseVar=0,$scope.check=function(x){x===$scope.collapseVar?$scope.collapseVar=0:$scope.collapseVar=x},$scope.breadcrumb=function(itemlist,$event){$rootScope.breadcrumblinks=itemlist},$scope.multiCheck=function(y){y===$scope.multiCollapseVar?$scope.multiCollapseVar=0:$scope.multiCollapseVar=y}}}}]).directive("rightSidebar",["$location",function(){return{templateUrl:"shared/templates/directives/right-sidebar.html",restrict:"E",replace:!0,scope:{},controller:function($scope,$rootScope,$cookies,$route,$http,RESTURL,$log,$location,$window,$timeout){$scope.$on("usermenuitems",function(event,data){$scope.selectedMenuItems=data,$timeout(function(){sidebarUserMenu.metisMenu()}),jQuery(".right-sidebar").css("width","300px"),jQuery(".manager-view").css("width","calc(100% - 300px)")}),$scope.$on("selectedUser",function($event,data){$scope.selectedUser=data}),$scope.deselectUser=function(){jQuery(".right-sidebar").css("width","0px"),jQuery(".manager-view").css("width","100%"),delete $scope.selectedUser,delete $scope.selectedMenuItems},$rootScope.$watch(function($rootScope){return $rootScope.section},function(newindex,oldindex){newindex>-1&&($scope.menuItems=[$scope.allMenuItems[newindex]],$scope.collapseVar=0)}),$scope.selectedMenu=$location.path(),$scope.collapseVar=0,$scope.multiCollapseVar=0,$scope.check=function(x){x===$scope.collapseVar?$scope.collapseVar=0:$scope.collapseVar=x},$scope.multiCheck=function(y){y===$scope.multiCollapseVar?$scope.multiCollapseVar=0:$scope.multiCollapseVar=y}}}}]).directive("stats",function(){return{templateUrl:"shared/templates/directives/stats.html",restrict:"E",replace:!0,scope:{model:"=",comments:"@",number:"@",name:"@",colour:"@",details:"@",type:"@","goto":"@"}}}).directive("notifications",function(){return{templateUrl:"shared/templates/directives/notifications.html",restrict:"E",replace:!0}}).directive("msgbox",function(){return{templateUrl:"shared/templates/directives/msgbox.html",restrict:"E",replace:!1}}).directive("alertBox",function($timeout){return{templateUrl:"shared/templates/directives/alert.html",restrict:"E",replace:!0,link:function($scope){$scope.$on("alertBox",function($event,data){$timeout(function(){delete $scope.alerts},5e3),$scope.alerts=[data]})}}}).directive("sidebarSearch",function(){return{templateUrl:"shared/templates/directives/sidebar-search.html",restrict:"E",replace:!0,scope:{},controller:function($scope){$scope.selectedMenu="home"}}}).directive("fileread",function($timeout){return{scope:{fileread:"="},link:function(scope,element,attributes){element.bind("change",function(changeEvent){var reader=new FileReader;reader.onload=function(loadEvent){scope.$apply(function(){scope.fileread=loadEvent.target.result}),$timeout(function(){scope.$parent.model[changeEvent.target.name]={file_name:changeEvent.target.files[0].name,file_content:scope.$parent.model[changeEvent.target.name]},document.querySelector("#image-preview").src=URL.createObjectURL(changeEvent.target.files[0])})},reader.readAsDataURL(changeEvent.target.files[0])})}}}),angular.module("ulakbus.auth",["ngRoute","ngCookies"]).controller("LoginCtrl",function($scope,$q,$timeout,$routeParams,$rootScope,$log,Generator,AuthService){$scope.url="login",$scope.form_params={},$scope.form_params.clear_wf=1,Generator.get_form($scope).then(function(data){$scope.form=[{key:"username",type:"string",title:"Kullanıcı Adı"},{key:"password",type:"password",title:"Şifre"},{type:"submit",title:"Giriş Yap"}]}),$scope.loggingIn=!1,$scope.onSubmit=function(form){$scope.$broadcast("schemaFormValidate"),form.$valid?($scope.loggingIn=!0,$rootScope.loginAttempt=1,AuthService.login($scope.url,$scope.model).error(function(data){$scope.message=data.title}).then(function(){$scope.loggingIn=!1})):$log.debug("not valid")},$log.debug("login attempt: ",$rootScope.loginAttempt)}),angular.module("ulakbus.auth").factory("AuthService",function($http,$rootScope,$location,$log,Generator,RESTURL){var authService={};return authService.login=function(url,credentials){return credentials.cmd="do",$http.post(RESTURL.url+url,credentials).success(function(data,status,headers,config){$rootScope.loggedInUser=!0}).error(function(data,status,headers,config){return data})},authService.logout=function(){return $log.debug("logout"),$http.post(RESTURL.url+"logout",{}).success(function(data){$rootScope.loggedInUser=!1,$log.debug("loggedout"),$location.path("/login")})},authService}),angular.module("ulakbus.dashboard",[]).config(function($uibTooltipProvider){$uibTooltipProvider.setTriggers({click:"mouseleave"})}).controller("DashCtrl",function($scope,$rootScope,$timeout,$http,$cookies,RESTURL,Generator){$scope.section=function(section_index){$rootScope.section=section_index},$scope.$on("authz",function(event,data){$rootScope.searchInputs=data}),$scope.keyword={student:"",staff:""},$scope.students=[],$scope.staffs=[],$scope.search=function(where){$timeout(function(){"personel"===where&&$scope.keyword.staff.length>2&&$scope.getItems(where,$scope.keyword.staff).success(function(data){$scope.staffs=data.results}),"ogrenci"===where&&$scope.keyword.student.length>2&&$scope.getItems(where,$scope.keyword.student).success(function(data){$scope.students=data.results})},500)},$scope.getItems=function(where,what){return $scope.showResults=!0,$http.get(RESTURL.url+"ara/"+where+"/"+what)},$scope.userPopover={templateUrl:"components/dashboard/user-info.html"},$scope.get_info=function(type,key){Generator.get_list({url:"crud",form_params:{model:type,object_id:key,cmd:"show"}}).then(function(data){$scope.userPopover.name=data.data.object.unicode,$scope.userPopover.tcno=data.data.object.tckn})},$scope.select=function(who,type){$rootScope.$broadcast("selectedUser",{name:who[0],tcno:who[1],key:who[2]}),$rootScope.$broadcast("menuitems",type),$scope.showResults=!1},$scope.$on("notifications",function(event,data){$scope.notifications=data}),$scope.$on("selectedUser",function($event,data){$scope.selectedUser=data}),$scope.deselectUser=function(){delete $scope.selectedUser,delete $scope.selectedMenuItems},$scope.markAsRead=function(items){$rootScope.$broadcast("markasread",items)}}).directive("sidebarNotifications",function(){return{templateUrl:"shared/templates/directives/sidebar-notification.html",restrict:"E",replace:!0,link:function($scope){}}}),angular.module("ulakbus.crud",["ui.bootstrap","schemaForm","ulakbus.formService"]).config(function(sfErrorMessageProvider){sfErrorMessageProvider.setDefaultMessage(302,"Bu alan zorunludur."),sfErrorMessageProvider.setDefaultMessage(200,"En az {{schema.minLength}} değer giriniz."),sfErrorMessageProvider.setDefaultMessage(201,"En fazla {{schema.minLength}} değer giriniz.")}).service("CrudUtility",function($log,$rootScope){return{generateParam:function(scope,routeParams,cmd){return scope.url=routeParams.wf,angular.forEach(routeParams,function(value,key){key.indexOf("_id")>-1&&"param_id"!==key&&(scope.param=key,scope.param_id=value)}),scope.form_params={model:routeParams.model,param:scope.param||routeParams.param,id:scope.param_id||routeParams.param_id,wf:routeParams.wf,object_id:routeParams.key,filters:{}},scope.param_id&&(scope.form_params.filters[scope.param]={values:[scope.param_id],type:"check"}),scope.model=scope.form_params.model,scope.wf=scope.form_params.wf,scope.param=scope.form_params.param,scope.param_id=scope.form_params.id,scope},listPageItems:function(scope,pageData){angular.forEach(pageData,function(value,key){scope[key]=value}),angular.forEach(scope.objects,function(value,key){if(key>0){var linkIndexes={};angular.forEach(value.actions,function(v,k){"link"===v.show_as&&(linkIndexes=v)}),angular.forEach(value.fields,function(v,k){value.actions.length>0&&linkIndexes.fields?scope.objects[key].fields[k]={type:linkIndexes.fields.indexOf(k)>-1?"link":"str",content:v,cmd:linkIndexes.cmd,mode:linkIndexes.mode}:scope.objects[key].fields[k]={type:"str",content:v}})}}),$log.debug(scope.objects)}}}).controller("CRUDCtrl",function($scope,$routeParams,Generator,CrudUtility){CrudUtility.generateParam($scope,$routeParams),Generator.get_wf($scope)}).controller("CRUDListFormCtrl",function($scope,$rootScope,$location,$http,$log,$uibModal,$timeout,Generator,$routeParams,CrudUtility){$scope.reload=function(reloadData){$scope.form_params.cmd=$scope.reload_cmd,$scope.form_params=angular.extend($scope.form_params,reloadData),$log.debug("reload data",$scope),Generator.get_wf($scope)},$scope.$on("reload_cmd",function(event,data){$scope.reload_cmd=data,$scope.reload({})}),$scope.$on("updateObjects",function($event,data){$scope.objects=data,CrudUtility.listPageItems($scope,{objects:$scope.objects})}),$scope.$on("formLocator",function(event){$scope.formgenerated=event.targetScope.formgenerated}),$scope.remove=function(item,type,index){$scope[type][item.title].model.splice(index,1),$scope[type][item.title].items.splice(index,1)},$scope.onSubmit=function(form){$scope.$broadcast("schemaFormValidate"),form.$valid&&Generator.submit($scope)},$scope.do_action=function(key,todo){Generator.doItemAction($scope,key,todo,todo.mode||"normal")},$scope.getNumber=function(num){return new Array(num)},$scope.createListObjects=function(){$scope.object.constructor===Array?$log.debug("new type show object"):$scope.object.type?$scope.object=[$scope.object]:$scope.object=[{type:"table",fields:angular.copy($scope.object)}]},$scope.showCmd=function(){CrudUtility.generateParam($scope,$routeParams,$routeParams.cmd);var pageData=Generator.getPageData();pageData.pageData===!0?($scope.object=pageData.object,Generator.setPageData({pageData:!1})):Generator.get_wf($scope).then(function(res){$scope.object=res.data.object,$scope.model=$routeParams.model}),$scope.createListObjects()},$scope.listFormCmd=function(){var setpageobjects=function(data){CrudUtility.listPageItems($scope,data),Generator.generate($scope,data),Generator.setPageData({pageData:!1})},pageData=Generator.getPageData();pageData.pageData===!0&&($log.debug("pagedata",pageData.pageData),CrudUtility.generateParam($scope,pageData,$routeParams.cmd),setpageobjects(pageData,pageData),$scope.second_client_cmd&&$scope.createListObjects()),(void 0===pageData.pageData||pageData.pageData===!1)&&(CrudUtility.generateParam($scope,$routeParams,$routeParams.cmd),Generator.get_wf($scope)),$scope.object&&$scope.createListObjects()},$scope.reloadCmd=function(){$scope.reload({})},$scope.resetCmd=function(){delete $scope.token,$scope.cmd="reset",Generator.get_wf($scope)};var executeCmd={show:$scope.showCmd,list:$scope.listFormCmd,form:$scope.listFormCmd,reload:$scope.reloadCmd,reset:$scope.resetCmd};return executeCmd[$routeParams.cmd]()}).directive("crudListDirective",function(){return{templateUrl:"components/crud/templates/list.html",restrict:"E",replace:!0}}).directive("crudFormDirective",function(){return{templateUrl:"components/crud/templates/form.html",restrict:"E",replace:!0}}).directive("crudShowDirective",function(){return{templateUrl:"components/crud/templates/show.html",restrict:"E",replace:!0}}).directive("formLocator",function(){return{link:function(scope){scope.$emit("formLocator")}}}).directive("crudFilters",function(Generator){return{templateUrl:"components/crud/templates/filter.html",restrict:"E",replace:!0,link:function($scope){$scope.form_params.filters=$scope.form_params.filters||{},$scope.filterList={},$scope.filterCollapsed={},$scope.$watch("list_filters",function(){angular.forEach($scope.list_filters,function(value,key){$scope.filterList[value.field]={values:value.values||[],type:value.type},$scope.filterCollapsed[value.field]=Object.keys($scope.filterCollapsed).length>0?!0:!1})}),$scope.collapseFilter=function(field){$scope.filterCollapsed[field]=!$scope.filterCollapsed[field]},$scope.status={startOpened:!1,endOpened:!1},$scope.dateFilterOpen=function($event,which){this.status[which]=!0},$scope.format="dd.MM.yyyy",$scope.filterSubmit=function(){angular.forEach($scope.filterList,function(value,key){if(value.model)if("date"===value.type){var dateValues=[null,null];angular.forEach(value.model,function(v,k){dateValues[k]=Generator.dateformatter(v)}),$scope.form_params.filters[key]={values:dateValues,type:value.type}}else $scope.form_params.filters[key]={values:Object.keys(value.model),type:value.type||"check"}}),Generator.get_wf($scope)}}}}),angular.module("ulakbus.debug",["ngRoute"]).controller("DebugCtrl",function($scope,$rootScope,$location){$scope.debug_queries=$rootScope.debug_queries}),angular.module("ulakbus.devSettings",["ngRoute"]).controller("DevSettingsCtrl",function($scope,$cookies,$rootScope,RESTURL){$scope.backendurl=$cookies.get("backendurl"),$scope.notificate=$cookies.get("notificate")||"on",$scope.changeSettings=function(what,set){document.cookie=what+"="+set,$scope[what]=set,$rootScope.$broadcast(what,set)},$scope.switchOnOff=function(pinn){return"on"==pinn?"off":"on"},$scope.setbackendurl=function(){$scope.changeSettings("backendurl",$scope.backendurl),RESTURL.url=$scope.backendurl},$scope.setnotification=function(){$scope.changeSettings("notificate",$scope.switchOnOff($scope.notificate))}}),angular.module("ulakbus").config(["$routeProvider",function($routeProvider){$routeProvider.when("/error/500",{templateUrl:"components/error_pages/500.html",controller:"500Ctrl"}).when("/error/404",{templateUrl:"components/error_pages/404.html",controller:"404Ctrl"})}]),angular.module("ulakbus.error_pages",["ngRoute"]).controller("500Ctrl",function($scope,$rootScope,$location){}).controller("404Ctrl",function($scope,$rootScope,$location){}),angular.module("ulakbus.version",["ulakbus.version.interpolate-filter","ulakbus.version.version-directive"]).value("version","0.6.10"),angular.module("ulakbus.version.interpolate-filter",[]).filter("interpolate",["version",function(version){return function(text){return String(text).replace(/\%VERSION\%/gm,version)}}]),angular.module("ulakbus.version.version-directive",[]).directive("appVersion",["version",function(version){return function(scope,elm,attrs){elm.text(version)}}]);